/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	René Beckmann - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sctunit.generator.c.CSCTUnitFileSystemAccessFactory
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import org.eclipse.xtext.generator.IFileSystemAccess

/**
 * 
 * @author René Beckmann - Initial contribution and API
 * 
 */

class TimerServiceHeader extends GTest {

	@Inject protected GeneratorEntry entry
	@Inject protected extension GenmodelEntries
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension CppNaming
	@Inject protected extension CppTypes
	@Inject protected extension Literals
	@Inject protected extension CppSpecifiers
	@Inject protected extension TimerServiceHeaderMethods
	@Inject protected extension StatechartAnnotations
	
	def generateTimerServiceHeader(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
		var timerServiceHeaderFileName = '''«timerServiceFileName.h»'''.toString
		var content = generateTimerServiceHeader
		fsa.generateFile(timerServiceHeaderFileName, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, content)
	}

	def protected generateTimerServiceHeader(SCTUnitClass it) {
		'''
			/*
			 * Timer Service for SCTUnit
			 */
			
			#ifndef SC_UNIT_TIMER_SERVICE_H_
			#define SC_UNIT_TIMER_SERVICE_H_
			
			«memoryInclude»
			
			#include "«typesModule.h»"
			#include "«statechart.statemachineModuleName.h»"
			«IF statechart.cycleBased || timed || statechart.hasTimedSubmachines»
			#include "«timerModule.h»"
			#include "«timerServiceModule.h»"
			«IF statechart.cycleBased»
			#include "«cycleBasedModule.h»"
			«ENDIF»
			«ENDIF»
			
			class «timerServiceClass»«IF timed || statechart.hasTimedSubmachines» : public «scTimerNS»::«timerInterface»«ENDIF» {
				public:
					«timerServiceClass»(«IF statechart.isCycleBased»«sharedPtr»«scNS»::«statechart.statemachineInterfaceName» «pointerType» statemachine_, «sc_integer.fqName» cycle_period_«IF timed || statechart.hasTimedSubmachines», «ENDIF»«ENDIF»«IF timed || statechart.hasTimedSubmachines»size_t maximal_parallel_time_events_«ENDIF»);
					virtual ~«timerServiceClass»() {
						«IF statechart.isCycleBased || timed || statechart.hasTimedSubmachines»«freeTasksArrayMember»«ENDIF»
					};
					void proceed_time(«sc_time.fqName» time_ms);
					void proceed_cycles(«sc_integer.fqName» cycles);
					«IF timed || statechart.hasTimedSubmachines»
					«setTimer»
					«unsetTimer»
					«IF entry.useSmartPointers»
					«unsetTimerRaw»
					«ENDIF»
					«ENDIF»
					virtual void cancel()«_noexcept»;
				private:
					«IF statechart.isCycleBased»
					«weakPtr»«scNS»::«statechart.statemachineInterfaceName» «pointerType» statemachine;
					«sc_integer.fqName» cycle_period;
					«sc_time.fqName» remaining_time_in_cycle;
					«ENDIF»
					«IF statechart.isCycleBased || timed || statechart.hasTimedSubmachines»
					«tasksArrayMember»
					«scTimerNS»::«timerServiceImplementation» timerServiceImplementation;
					«ENDIF»
			};
			#endif /* SC_UNIT_TIMER_SERVICE_H_ */
			
		'''
	}
	
	def protected tasksArrayMember()'''
	«sharedPtr»«scTimerNS»::«timerServiceImplementationTask» «pointerType»tasks;
	'''
	
	def protected freeTasksArrayMember()'''delete [] tasks;'''
}
