/**
 * Copyright (c) 2024-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.yet.sct.debugger.interpreter

import com.yakindu.base.expressions.interpreter.base.IInterpreter.Instance
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sruntime.ExecutionContext
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecInstanceFactory
import com.google.inject.Inject
import com.google.inject.name.Named

import static com.yakindu.yet.core.config.IYETConfigParameters.INSTANCE_NAME
import com.yakindu.yet.core.YETTrace

/**
 * Instance factory for statechart instances which interprete YET events.
 *  
 * @author axel terfloth
 */
class YETInstancefactory extends SexecInstanceFactory {

	// TODO change handling of instance name for multi statechart trace support.
	@Inject	@Named(INSTANCE_NAME) protected String instanceName;

	@Inject protected YETTrace trace;
	
	override protected Instance createInstanceExecution(ExecutionContext instanceSlot, ExecutionFlow flow) {
		new YETStatechartInstance => [
			it.injectMembers
			it.setUp(instanceSlot, instanceContext, flow.sourceElement as Statechart)
			it.traceScope.name = if(instanceName.isNullOrEmpty) 
									flow.name 
								else 
									instanceName 
			trace.addScope(it.traceScope)	
		]
	} 
	
}