/**
 * Copyright (c) 22020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Axel Terfloth - initial contribution
 *
 */
package com.yakindu.yet.sct.debugger.interpreter

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecExecution
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecInterpreter
import com.yakindu.yet.core.YETEvent
import com.yakindu.yet.core.YETTrace

/**
 * A YETInterpreter handles a YETTrace.
 * 
 * @author axel terfloth
 */
@Singleton
class YETInterpreter extends SexecInterpreter {
			
	@Inject protected YETTrace trace;

	@Inject new(SexecExecution exec) {
		super(exec)
	}
			
		
	def dispatch evaluate(Object program) {
		super.evaluate(null, program)	
	}
		
	def dispatch evaluate(YETEvent<?> it) {
		logDebug["YETInterpreter.evaluate(" + it + ")"]
		
		if(! trace.hasFutureEvents) {
			_scheduleTraceEventConsumption(it)
		}
		trace.executed(it)
		null
	}
		
	def protected void consumeTraceEvents(long timestamp) {
		while(trace.nextFutureEvent!==null && trace.nextFutureEvent.timestamp <= timestamp) {
			trace.consumeNextFutureEvent
		}
		
		if ( trace.hasFutureEvents ) {
			_scheduleTraceEventConsumption(trace.nextFutureEvent)
		}
	}
	
	def protected void _scheduleTraceEventConsumption(YETEvent<?> it) {
		_schedule( 
			"consume YET events until " + it.timestamp
			,it.timestamp - currentTime
			,false
			,[ consumeTraceEvents(it.timestamp)] )			
	}
}