/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
 
package com.yakindu.sct.simulation.core.sexec.interpreter

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.types.Event
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.DoWhile
import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.Execution
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.HistoryEntry
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.SaveHistory
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.StateSwitch
import com.yakindu.sct.model.sexec.Statement
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.Trace
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sexec.concepts.BufferEvent
import com.yakindu.sct.model.sexec.concepts.StateMachineBehaviorConcept
import com.yakindu.sct.model.sruntime.ExecutionEvent
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.base.expressions.interpreter.base.ExpressionExecution
import com.yakindu.base.expressions.expressions.ArgumentExpression

/**
 * Provides executions for elements (steps) defined by sexec.
 * This implementation handles all steps which are not related to 
 * the concept of state machines. All those relates to states etc. are delegated.
 * 
 * @author axel terfloth
 */
class SexecExecution extends ExpressionExecution {
	

	@Inject extension StateMachineBehaviorConcept smbc
		
	@Inject extension BufferEvent
	@Inject extension OriginTracing


	//=================================================================================
	// execution of stext expressions is done here ...
	
	def dispatch void execution(ActiveStateReferenceExpression it) { _delegate }


	//=================================================================================
	// execution of sexec steps...

	def dispatch void execution(Call it) { _delegate }
	

	def dispatch void execution(Check it) {
		if (condition === null ) {
			_return[true]	
		}
		else {
			condition._exec
			_value			
		}
	}

	def dispatch void execution(Execution it) {
		statement._exec
	}

	def dispatch void execution(DoWhile loop) {
		loop.body._exec
		loop.check._exec
		_value
		_execute[
			val checkResult = popValue
			if (checkResult == true) loop._exec
		]
	}
	
	def dispatch void execution(If it) {
		check._exec
		_value
		_execute ('if', [
			val checkResult = (popValue == true)
			if (checkResult) thenStep._exec
			else if (elseStep !== null) elseStep._exec
		])
	}
	
	def dispatch void execution(Sequence it) {
		if (it.isStateMachineConcept)
			_delegate 
		else 
			steps.forEach[ step | step._exec ]
	}
	
	def dispatch void execution(Statement it) {
		it.expression._exec
	}

	def dispatch void execution(LocalVariableDefinition it) {
		if ( initialValue !== null) {
			initialValue._exec
			_value
			_execute('''var «it.variable.name»''', [ 
				val value = popValue
				defineVariable(it.variable.name, value)
			]) 
		}
	}

	def dispatch void execution(Trace it) { _delegate }
	
	def dispatch void execution(EnterState it) { _delegate }

	def dispatch void execution(ExitState it) { _delegate }

	def dispatch void execution(SaveHistory it) { _delegate }

	def dispatch void execution(HistoryEntry it) { _delegate }

	def dispatch void execution(StateSwitch it) { _delegate } 
	
	def dispatch void execution(ScheduleTimeEvent it) { 
		it.timeValue._exec
		_value
		_return [
			resolve(null, it.timeEvent.symbol)
		]
		_execute('''schedule «it.timeEvent.name»''', [
			val timeEventSlot = popValue as ExecutionEvent
			val duration = popValue as Long
			_schedule(timeEventSlot.timeEventIdentifier, duration, it.timeEvent.periodic, [
				raise(timeEventSlot, null)
			])	
		])		
	}

	
	def dispatch void execution (UnscheduleTimeEvent it) {
		_return [
			resolve(null, it.timeEvent.symbol)
		]
		_execute('''unschedule «it.timeEvent.name»''', [
			val timeEventSlot = popValue as ExecutionEvent
			_unschedule(timeEventSlot.timeEventIdentifier)
		])		
	}

	def protected String timeEventIdentifier(ExecutionEvent it) {
		'''«(it.eContainer.eContainer as ExecutionSlot).fqName».«it.fqName»'''
	}
	
	
	def dispatch void execution(Sequence item, ArgumentExpression context) {
		if (item.isStateMachineConcept)
			item._delegate
		else
			item.execution
	}
	
	protected override dispatch executeResolve(NamedElement item, ElementReferenceExpression context){
		val refParent = item.eContainer
		if (refParent instanceof InterfaceScope) {
			val scopeName = if (refParent.name.nullOrEmpty) 
				"default"
			else 
				refParent.name
	
			resolve(null, scopeName).resolve(item.symbol)
		} else super._executeResolve(item, context)		
	}
	
	
	def dispatch void executionCall(Method it) {
		_delegate				
	}
	
	def dispatch String symbol(TimeEvent it) {
		fullyQualifiedName.toString
	}
	
	def dispatch String symbol(Event it) {
		// resolve by FQN because time event names are not unique
		if (isBufferEvent && originTraces.exists[o | o instanceof TimeEvent])
			fullyQualifiedName.toString
		else
			super._symbol(it)
	}
	
}