/**
* Copyright (c) 2018-2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Axel Terfloth - itemis AG
*
*/
package com.yakindu.sct.generator.cpp.qt

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.files.TimerServiceHeader
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class QtTimerServiceHeader extends TimerServiceHeader {
	
	@Inject extension QtNaming
	@Inject extension GenmodelEntries
	
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «timerServiceModule.define»_H_
		#define «timerServiceModule.define»_H_


		#include <QObject>
		#include <QTimer>
		#include <QMap>
		#include <QPair>
		
		#include "«(timerModule.h).relativeTo(timerServiceModule.h)»"
		
		
		namespace sc
		{
		
		namespace qt
		{
		
		    class SCTimer : public QTimer
		    {
		        Q_OBJECT
		
		    public:
		        explicit SCTimer(QObject * parent, «weakPtr»sc::timer::TimedInterface«pointerType» machine, const sc::eventid id);
		        
		        virtual ~SCTimer();
		
		    signals:
		        void fireTimeEvent(«sharedPtr»sc::timer::TimedInterface«pointerType» machine, sc::eventid event);
		
		    public slots:
		        void triggerTimeEvent();
		
		    protected:
		        «weakPtr»sc::timer::TimedInterface«pointerType» machine;
		        sc::eventid eventId;
		    };
		
		
		
		    class SCTimerService : public QObject, public sc::timer::TimerServiceInterface
		    {
		        Q_OBJECT
		
		    public:
		        explicit SCTimerService(QObject *parent);
		        
		        virtual ~SCTimerService();
		
		        virtual void setTimer(«sharedPtr»sc::timer::TimedInterface«pointerType» statemachine, sc::eventid event, «sc_time.fqName» time_ms, bool isPeriodic);
		        virtual void unsetTimer(«sharedPtr»sc::timer::TimedInterface«pointerType» statemachine, sc::eventid event);
		        «IF genExt.useSmartPointers(entry)»
		        virtual void unsetTimerRaw(sc::timer::TimedInterface* statemachine_, sc::eventid event);
				«ENDIF»
		        virtual void cancel();
		
		    signals:
		
		    public slots:
		        void raiseTimeEvent(«sharedPtr»sc::timer::TimedInterface«pointerType» machine, sc::eventid event);
		
		    protected:
		        QMap<«sharedPtr»sc::timer::TimedInterface«pointerType»,QMap<sc::eventid, «sharedPtr»SCTimer«pointerType»>*> machineTimerMapMap;
		        «sharedPtr»SCTimer«pointerType» getTimer(«sharedPtr»sc::timer::TimedInterface«pointerType» machine, sc::eventid event);
		
		    };
		
		} // namespace qt
		
		} // namespace sc
		
		#endif // «timerServiceModule.define»_H_
		

	'''
	
}