/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.qt.codemodel

import com.yakindu.base.types.AnnotatableElement
import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder

/**
 *
 * @author axel terfloth - Builder for Qt specific code model parts.
 *
 */
class QtCodeModelBuilder {
	
	@Inject protected extension TypeBuilder
	
	def <T extends AnnotatableElement> T _signal(T e) {
		e._annotate(QtMemberTypeAnnotations.SIGNAL_ANNOTATION)
	}
	
	def <T extends AnnotatableElement> T _slot(T e) {
		e._annotate(QtMemberTypeAnnotations.SLOT_ANNOTATION)
	}
	
}