/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.cpp.qt.submodules

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.cpp.qt.QtExtensions
import com.yakindu.sct.generator.cpp.qt.codemodel.QtEventAccessors
import com.yakindu.sct.generator.cpp11.submodules.Cpp11InterfaceFunctions
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.VariableDefinition

class QtInterfaceFunctions extends Cpp11InterfaceFunctions {
	
	@Inject protected extension QtExtensions
	@Inject protected extension QtEventAccessors

	protected override CharSequence observerHandler(Property variable, String subscription) {
		val connect_or_disconnect = if ( subscription == "subscribe" ) "connect" else "disconnect"
		// TODO: ICodegenTypeSystemAccess always provides the type as pointer '*'. So we have to cut it off 
		val senderTypePointerName = variable.typeSpecifier.targetLanguageName
		val senderTypeName = 	if (senderTypePointerName.endsWith("*")) 
									senderTypePointerName.subSequence(0, senderTypePointerName.length-1) 
								else 
									senderTypePointerName
		
		'''«IF variable.needsShadowEventMapping»
		if(this->«variable.localAccess» != «NULL_LITERAL»)
		{
			«FOR e : variable.shadowEventsByScope.keySet.map[members].flatten.filter(Event)»
				«val outEvent = variable.getShadowEvent(e)»
				«IF outEvent !== null»
				«connect_or_disconnect»(«variable.name.asEscapedIdentifier»_, &«senderTypeName»::«e.signalSlotName», «IF variable.scope.isNamedScope»«parentMember»«ELSE»this«ENDIF», &«outEvent.flow.module»::«outEvent.scope.namedInstanceAccess»«variable.getShadowEvent(e).signalSlotName»);«ENDIF»
			«ENDFOR»
		}
		«ENDIF»'''	
	}
	
	override notEmptyClass(Scope it){
		hasIncomingEvents || useOutEventObservables || useOutEventGetters || !members.filter(Operation).nullOrEmpty || !members.filter(VariableDefinition).nullOrEmpty
	}
	
}