/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgen.GeneratorModel
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.*
import static com.yakindu.sct.generator.java.features.IJavaFeatureConstants.*

import static extension org.eclipse.xtext.EcoreUtil2.*

class GenmodelEntries {
	
	@Inject extension StringHelper

	def private getLicenseFeature(GeneratorEntry it) {
		getFeatureConfiguration(LICENSE_HEADER)
	}

	def private getNamingFeature(GeneratorEntry it) {
		getFeatureConfiguration(NAMING_FEATURE)
	}

	def private getGeneralFeatures(GeneratorEntry it) {
		getFeatureConfiguration(GENERAL_FEATURES)
	}

	def private FeatureParameterValue getBasePackageParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(BASE_PACKAGE)
	}
	
	def private FeatureParameterValue getLibraryPackageParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(LIBRARY_PACKAGE)
	}

	def private FeatureParameterValue getTypeNameParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(TYPE_NAME)
	}

	def private FeatureParameterValue getLicenseTextParameter(GeneratorEntry it) {
		licenseFeature?.getParameterValue(LICENSE_TEXT)
	}

	def private FeatureParameterValue getTimerServiceParameter(GeneratorEntry it) {
		generalFeatures?.getParameterValue(TIMER_SERVICE)
	}
	
	def private FeatureParameterValue getVirtualTimerServiceParameter(GeneratorEntry it) {
		generalFeatures?.getParameterValue(VIRTUAL_TIMER_SERVICE)
	}

	def private FeatureParameterValue getRuntimeServiceParameter(GeneratorEntry it) {
		generalFeatures?.getParameterValue(RUNTIME_SERVICE)
	}

	def private FeatureParameterValue getSynchronizedParameter(GeneratorEntry it) {
		generalFeatures?.getParameterValue(SYNCHRONIZED)
	}
	
	def private FeatureParameterValue getRunnableParameter(GeneratorEntry it) {
		generalFeatures?.getParameterValue(RUNNABLE)
	}

	def getLicenseText(GeneratorEntry it) {
		if (licenseTextParameter !== null)
			"/** " + licenseTextParameter.stringValue.trim + " */"
		else
			LICENSE_STANDARD_TEXT
	}

	def getBasePackage(GeneratorEntry it) {
		(basePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(statechart?.namespace)
	}
	
	def getBasePackage(GeneratorEntry entry, Statechart context) {
		val contextEntry = (entry.model.entryFor(context) ?: entry)
		(contextEntry.basePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(context.namespace)
	}
	
	private def getModel(GeneratorEntry it) {
		getContainerOfType(GeneratorModel)
	}
	
	private def entryFor(GeneratorModel it, EObject element) {
		entries.findFirst[EcoreUtil.equals(elementRef, element)]
	}
	
	def getLibraryPackage(GeneratorEntry it) {
		libraryPackageParameter?.stringValue ?: LIBRARY_PACKAGE_DEFAULT
	}

	def getTypeName(GeneratorEntry it) {
		typeNameParameter?.stringValue
	}

	def createTimerService(GeneratorEntry it) {
		if (timerServiceParameter !== null) {
			return timerServiceParameter.booleanValue
		}
		return false
	}
	
	def createVirtualTimerService(GeneratorEntry it) {
		if(virtualTimerServiceParameter !== null) {
			return virtualTimerServiceParameter.booleanValue;
		}
	}

	def createRuntimeService(GeneratorEntry it) {
		if (runtimeServiceParameter !== null) {
			return runtimeServiceParameter.booleanValue
		}
		return false
	}
	
	def private getTracingFeature(GeneratorEntry it) {
		getFeatureConfiguration(FEATURE_TRACING)
	}
	
	def getTracingEnterState(GeneratorEntry it){
		val enterStateParameter = tracingFeature?.getParameterValue(PARAMETER_TRACING_ENTER_STATE)
		if (enterStateParameter !== null) {
			return enterStateParameter.booleanValue
		}
		return false
	}
	
	def getTracingExitState(GeneratorEntry it){
		val exitStateParameter = tracingFeature?.getParameterValue(PARAMETER_TRACING_EXIT_STATE)
		if (exitStateParameter !== null) {
			return exitStateParameter.booleanValue
		}
		return false
	}
	
	def tracingUsed(GeneratorEntry it) {
		return (tracingEnterState || tracingExitState)
	}
	
	def tracingGeneric(GeneratorEntry it) {
		val genericParameter = tracingFeature?.getParameterValue(PARAMETER_TRACING_GENERIC)
		if (genericParameter !== null) {
			return genericParameter.booleanValue
		}
		return false
			
	}
	
	def isSynchronized(GeneratorEntry it) {
		if(synchronizedParameter !== null) {
			synchronizedParameter.booleanValue
		} else {
			false
		}
	}
	
	def isRunnable(GeneratorEntry it) {
		if(runnableParameter !== null) {
			runnableParameter.booleanValue
		} else {
			false
		}
	}
	
	def getStatechart(GeneratorEntry it) {
		if (elementRef instanceof Statechart) 
			elementRef as Statechart
		else
			null as Statechart
	}
}
