/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class IEventDriven {
	
	
	@Inject extension Naming 
	@Inject extension GenmodelEntries
	@Inject extension OutputConfigProvider
	@Inject extension ICoreLibraryHelper
	@Inject extension StringHelper
	 
	def generateIEventDriven(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + iEventDriven.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def private content(GeneratorEntry it) {
		'''
			«licenseText»
			«IF !libraryPackage.isNullOrEmpty»package «libraryPackage»;«ENDIF»
			
			/**
			 * Interface for event-driven state machines.
			 */
			public interface «iEventDriven()» extends «iStatemachine» {
			
				/**
				* Start a run-to-completion step without any event.
				*/
				public void triggerWithoutEvent();
			}
		'''
	}
}