/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class ITimerService {
	
	@Inject extension Naming 
	@Inject extension GenmodelEntries
	@Inject extension OutputConfigProvider
	@Inject extension ICoreLibraryHelper
	@Inject extension StringHelper
	
	def generateITimerService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + iTimerService.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def content(GeneratorEntry entry) {
		content(entry.licenseText, entry.libraryPackage)
	}
	
	def content(String licenseText, String pkg) {
		'''
			«licenseText»
			«IF !pkg.isNullOrEmpty»package «pkg»;«ENDIF»
			
			/**
			 * Defines methods to set and unset timers for a state machine's timed event triggers.
			 * 
			 */
			public interface «iTimerService» {
			
				/**
				 * Starts the timing for a given time event id.
				 * 
				 * @param callback		an «iTimed» object that is called when the timer expires
				 * @param eventID		the id of the state machine's time event
				 * @param time			time in milliseconds after which the time event should be triggered
				 * @param isPeriodic	set to true to trigger the time event periodically
				 */
				public void setTimer(«iTimed» callback, int eventID, long time, boolean isPeriodic);
			
				/**
				 * Unsets a time event.
				 * 
				 * @param callback	an «iTimed» object that is called when the timer expires
				 * @param eventID	the id of the state machine's time event
				 */
				public void unsetTimer(«iTimed» callback, int eventID);
			}
		'''
	}
}