/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaIncludeProvider
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.OutEventObservables
import com.yakindu.sct.generator.java.submodules.EventCode
import com.yakindu.sct.generator.java.submodules.FieldDeclarationGenerator
import com.yakindu.sct.generator.java.submodules.InterfaceFunctionsGenerator
import com.yakindu.sct.generator.java.submodules.InternalFunctionsGenerator
import com.yakindu.sct.generator.java.submodules.InternalTypes
import com.yakindu.sct.generator.java.submodules.MethodGenerator
import com.yakindu.sct.generator.java.submodules.StatemachineFunctionsGenerator
import com.yakindu.sct.generator.java.submodules.TimingFunctions
import com.yakindu.sct.generator.java.submodules.eventdriven.RunnableExtension
import com.yakindu.sct.generator.java.submodules.lifecycle.IsActive
import com.yakindu.sct.generator.java.submodules.lifecycle.IsFinal
import com.yakindu.sct.generator.java.submodules.lifecycle.IsStateActive
import com.yakindu.sct.generator.java.templates.ClassTemplate
import com.yakindu.sct.generator.java.templates.FileTemplate
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.Set
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.model.sexec.concepts.EventQueue

class Statemachine {

	@Inject protected extension EventQueue
	 
	@Inject Set<JavaIncludeProvider> includeProviders
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension SExecExtensions
	@Inject extension StringHelper
	
	@Inject extension EventCode
	@Inject extension InterfaceFunctionsGenerator
	@Inject extension InternalFunctionsGenerator
	@Inject extension StatemachineFunctionsGenerator
	@Inject extension FieldDeclarationGenerator
	@Inject extension TimingFunctions

	@Inject extension IsActive
	@Inject extension IsStateActive
	@Inject extension IsFinal
	@Inject extension RunnableExtension
	
	@Inject extension MethodGenerator
	@Inject extension VisibilityAnnotations
	
	@Inject extension GeneratorPredicate
	@Inject extension ShadowEventExtensions
	@Inject extension OutEventObservables
	
	@Inject extension InternalTypes
	@Inject extension IFlowConfiguration
	
	protected ExecutionFlow flow
	protected GeneratorEntry entry
		
	def generateStatemachine(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		this.flow = flow
		this.entry = entry
		var filename = entry.basePackage.toPath + '/' + flow.statemachineClassName.java
		fsa.generateFile(filename, content)
	}
	
	def protected content() { 
		FileTemplate
			.create
			.fileComment(entry.licenseText)
			.packageName(entry.basePackage)
			
			.addImport(entry.libraryPackage.dot(iCycleBased), isCycleBased && !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(iEventDriven), flow.isEventDriven && !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(iStatemachine), !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(iTimed), flow.timed && !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(iTimerService), flow.timed && !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(tracingListener), entry.tracingUsed && !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(traceEventClass), entry.tracingGeneric && !entry.libraryPackage.isEmpty)
			.addImport(entry.libraryPackage.dot(traceEventTypeEnum), entry.tracingGeneric && !entry.libraryPackage.isEmpty)
			
			.addImport("java.util.LinkedList", flow.requiresEventQueue && !needsSynchronized)
			.addImport("java.util.Queue", flow.requiresEventQueue && !needsSynchronized)
			.addImport("java.util.concurrent.BlockingQueue", flow.requiresEventQueue && needsSynchronized)
			.addImport("java.util.concurrent.LinkedBlockingQueue", flow.requiresEventQueue && needsSynchronized)
			
			.addImport(entry.rxPackage.dot(observableClass), (useOutEventObservables && flow.hasOutgoingEvents) || entry.tracingGeneric)
			.addImport(entry.rxPackage.dot(observerClass), !flow.shadowEvents.nullOrEmpty)
			
			.addImport("java.util.LinkedList", entry.tracingUsed)
			.addImport("java.util.List", entry.tracingUsed)
			
			.addImports(includeProviders.map[getImports(flow, entry)].flatten)
			
			.classTemplate(classTemplate)
			.generate
	}
	
	def protected ClassTemplate classTemplate() {
		val cT = ClassTemplate
			.create
			.className(flow.statemachineClassName)
			.classContent(
				classContent
			)
		if (flow.timed)    cT.addInterface(iTimed)
		if (isCycleBased)  cT.addInterface(iCycleBased) else cT.addInterface(iEventDriven)
		if (needsRunnable) cT.addInterface("Runnable")
		
		cT
	}
	
	def protected classContent() {
		'''
		«IF needsRunnable»
		
		«flow.runnable»
		
		«ENDIF»
		«flow.interfaceClasses(entry)»
		«flow.internalTypes»
		«flow.createFieldDeclarations(entry)»
		«flow.createConstructor(entry)»
		«flow.methods.filter[ isPublic ].toImplementation»
		«flow.isActive»
		«flow.isFinal»
		«flow.methods.filter[ !isPublic ].toImplementation»
		«flow.nextEvent»
		«flow.isStateActive»
		«flow.timingFunctions»
		«flow.interfaceAccessors(entry)»
		«flow.internalScopeFunctions»
		«flow.defaultInterfaceFunctions(entry)»
		«flow.functionImplementations»
		'''
	}

}
