/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.stext.stext.StatechartScope

class OperationCallbackCode {
	
	@Inject extension Naming
	@Inject extension SExecExtensions
	@Inject extension Synchronized
	@Inject extension OperationSignatureCode
	
	def generateOperationCallback(StatechartScope it) '''
		«generateOperationCallbackInterface»
		
		private «operationCallbackClass» «operationCallbackInstance»;
		
		public «sync»void set«operationCallbackClass»(«operationCallbackClass» «operationCallbackInstance») {
			this.«operationCallbackInstance» = «operationCallbackInstance»;
		}
	'''
	
	def generateOperationCallbackInterface(StatechartScope it) '''
		public interface «operationCallbackClass» {
		
			«FOR operation : operations»
				«operation.toSignature»
				
			«ENDFOR»
		}
	'''
}