/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.base.types.Parameter

class OperationSignatureCode {
	
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension JavaNamingService
	
	def toSignature(OperationDefinition it) 
		'''public «typeSpecifier.targetLanguageName» «name.asEscapedIdentifier»(«FOR p : parameters SEPARATOR ', '»«p.toCode»«ENDFOR»);'''
	
	protected def toCode(Parameter it) 
		'''«typeSpecifier.targetLanguageName»«IF isVarArgs»...«ENDIF» «name.asEscapedIdentifier»'''
		
}