/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.java.extensions

import com.google.inject.Inject
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.generator.java.Naming

class CallbackExtensions {

	@Inject extension SCTUnitJavaNaming
	@Inject extension Naming

	def dispatch CharSequence setCallBack(Scope it) {}
	def dispatch CharSequence setCallBack(InternalScope it)  '''«operationCallbackClass» «mockObjectName»;'''
	def dispatch CharSequence setCallBack(InterfaceScope it) '''«IF !name.nullOrEmpty»«interfaceTypeName».«ENDIF»«operationCallbackClass» «mockObjectName»;'''
	
	def dispatch CharSequence setOperationCallback(Scope it) {}
	def dispatch CharSequence setOperationCallback(InternalScope it)  '''statemachine.setInternalOperationCallback(«mockObjectName»);'''
	def dispatch CharSequence setOperationCallback(InterfaceScope it) '''statemachine.«IF !name.nullOrEmpty»«valueGetter»().«ENDIF»set«operationCallbackClass»(«mockObjectName»);'''
	
	def dispatch CharSequence unsetOperationCallback(Scope it) {}
	def dispatch CharSequence unsetOperationCallback(InternalScope it)  '''statemachine.setInternalOperationCallback(null);'''
	def dispatch CharSequence unsetOperationCallback(InterfaceScope it) '''statemachine.«IF !name.nullOrEmpty»«valueGetter»().«ENDIF»set«operationCallbackClass»(null);'''

}
