/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.json.transformation

import org.eclipse.gmf.runtime.notation.NotationPackage
import org.eclipse.emf.ecore.EPackage
import com.yakindu.sct.model.sgraph.SGraphPackage

/**
 * Does a standalone setup for the sgraph and gmf-notation emf packages required by the transformations.
 * It cares about registering the notation package with all relevant uris.
 * 
 * @author axel terfloth - initial contribution
 */
class TransformationStandaloneSetup {

	static def apply() {

		val sgrapgPackage = SGraphPackage.eINSTANCE
		val notationPackage = NotationPackage.eINSTANCE
		
		// additionally register NotationPackage with 1.0.2 version uri.
		EPackage.Registry.INSTANCE.put("http://www.eclipse.org/gmf/runtime/1.0.2/notation", notationPackage)
	}

}
