/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.model.bindings

import com.google.inject.Inject
import com.google.inject.Injector
import com.google.inject.Singleton
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypesPackage
import com.yakindu.base.types.libraries.AbstractTypeLibrary
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

/**
 * Type library which provides a set are declarartions 
 * for binding and orchestration purpose. It defines modeling 
 * concepts for end users. 
 * 
 * @author axel terfloth - initial contribution
 */
@Singleton
class BindingsTypeLibrary extends AbstractTypeLibrary {

	public static val BINDINGS_PACKAGE_NAME = "create.bindings"

	public static val LIBRARY = "create.bindings"
	public static val LIBRARY_URI = URI.createURI(LIBRARY)
	
	public static val ON_INIT_EVENT_NAME = "onInit"
	public static val BIND_OPERATION_NAME = "bind"
	
	public static val IN_ANNOTATION_NAME = "In"
	public static val OUT_ANNOTATION_NAME = "Out"
	
	protected extension TypesPackage typesPackage= TypesPackage.eINSTANCE
	
	def create it : memberWithName(Event, ON_INIT_EVENT_NAME) onInitEvent() {
	}
	
	def isOnInitEvent(EObject it) {
		EcoreUtil.equals(it, onInitEvent)
	}
	
	def create it : memberWithName(Operation, BIND_OPERATION_NAME) bindOperation() {
	}
	
	def isBindOperation(EObject it) {
		EcoreUtil.equals(it, bindOperation)
	}
	
	def isIn(AnnotatableElement it) {
		defines(IN_ANNOTATION_NAME)
	}

	def isOut(AnnotatableElement it) {
		defines(OUT_ANNOTATION_NAME)
	}
	
	def protected defines(AnnotatableElement it, String annotationName) {
		it?.annotationInfo?.annotations?.exists[it.type.name == annotationName]
	}
	
	
	override protected createLibraryPackage() {
		val bPkg = BINDINGS_PACKAGE_NAME._package => [
			member += "bind"._op(_void) => [
				_param("from", _any)
				_param("to", _any)
			]
			
			member += "onInit"._event._in => [
				typeSpecifier = _void._typeSpecifier
			]
			
			// TODO : we will require this in future
//			member += "Part"._annotationType => [
//				targets += #[property]
//			]
				
			member += "In"._annotationType => [
				targets += #[property]
			]
			member += "Out"._annotationType => [
				targets += #[property]
			]
			
		]

		return bPkg
	}

	override getLibraryURI() {
		LIBRARY_URI
	}
	
	static class Provider implements ITypeLibraryProvider {
		@Inject Injector injector
		override provide() {
			#[ injector.getInstance(BindingsTypeLibrary) ]
		}
	}
}
