/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.model.bindings

import com.yakindu.base.types.Property
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Expression
import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder

/**
 * This class defines the concept for specifying change notification for properties. 
 * Notification code can be associated with a property. So different notifiers can be hook into a
 * properties setter. Semantically these notifications must be executed after the actual value change took place.
 * 
 * @author axel terfloth
 */
class PropertyChangedNotification {
	
	@Inject protected extension TypeBuilder
	
	def addChangeNotifictation(Property p, String name, Expression notify) {
		var updates = p.metaFeatures.filter(Declaration).findFirst[it.name == "_changed_notifications_"]
		if (updates === null) {
			updates = _decl("_changed_notifications_")
			p.metaFeatures += updates
		}
		updates.metaFeatures += _op("notify_"+name, _void) => [
			implementation = notify
		]
	}
	
	def changedNotifications(Property it) {
		val meta = metaFeatures
			.filter(Declaration)
			.findFirst[name == "_changed_notifications_"]
			
		if (meta !== null)
			meta.metaFeatures
				.filter(Operation)
				.filter[name.startsWith("notify_")]
				.toList
		else
			#[]
	}
	
	
}