/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.model.bindings

import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.Type
import com.yakindu.base.types.Operation
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.types.annotations.TypeAnnotations
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.types.TypeSpecifier
import com.google.inject.Singleton

/**
 * This class defines reactive base concepts like observable and observer. 
 * which can be used during sequencing and within code models.  
 * 
 * @author axel terfloth
 */
@Singleton
class ReactiveModel {
	
	public static val OBSERVABLE = "Observable"
	public static val OBSERVER = "Observer"
	public static val SIMPLE_OBSERVER = "SimpleObserver"
	
	@Inject protected extension TypeBuilder
	@Inject protected extension TypeAnnotations
	@Inject protected extension ExpressionBuilder
	
	def create observable : _complexType(OBSERVABLE) observableType() {
		val T = observable._typeParam("T")
		observable.annotateAsReferenceType
		val observers = _part("observers") => [ 
			_protected
			typeSpecifier = _array._typeSpecifier(simpleObserverType._typeSpecifier)
			observable.features += it
		]
		val next_value = _parameter("value", T)
		observable.features += _op("next", _void) => [
			_param(next_value)
			val i = _variable("i", _integer) => [ initialValue = 0._value ]
			val o = _variable("o", simpleObserverType._typeSpecifier) => [ initialValue = _null ]
			_body(
				_block(
					_declare(i),
					_declare(o),
					_while(
						i._ref._smaller(observers._ref._call(_array_size)),
						_block(
							o._ref._assign(observers._ref => [
								arrayAccess = true
								arraySelector += i._ref
							]),
							o._ref._call(observerTypeNext)._with(next_value._ref),
							i._ref._assign(AssignmentOperator.ADD_ASSIGN, 1._value)
						)
					)
				)
			)
		]
		rxPackage.member += observable
	}
	
	def observableTypeObservers() {
		observableType.features.filter(com.yakindu.base.types.Property).findFirst["observers" == name]
	}
	
	
	def create it : _complexType(OBSERVER) observerType() {
		val T = it._typeParam("T")
		features += _op("next", _void) => [
			_param("value", T._typeSpecifier)
		]
		rxPackage.member += it
	}
	
	def observerTypeNext() {
		observerType.features.filter(Operation).findFirst["next" == name]
	}
	
	def create it : _complexType(SIMPLE_OBSERVER) simpleObserverType() {
		val T = it._typeParam("T")
		it.annotateAsReferenceType
		superTypes += observerType._typeSpecifier(T._typeSpecifier)
		val lambda = _variable("lambda", _function)
		features += lambda
		
		val subscribe_observable = _parameter("observable", observableType._typeSpecifier(T._typeSpecifier))
		features += _op("subscribe", _void) => [
			_param(subscribe_observable)
			_body(
				_block(
					subscribe_observable._ref
						._dot(observableTypeObservers)
						._call(_array_add)._with(_this)
				)
			)
		]
		features += _op("next", _void) => [
			_body(
				_block(
					lambda._ref
						._call(_function_apply)
				)
			)
		]
		
		rxPackage.member += it
	}
	
	def protected create it : _package("rx") rxPackage() {
		scPackage.member += it
	}
	
	def protected create it : _package("sc") scPackage() {}

	def isObservableType(Type it) { EcoreUtil.equals(it, observableType) }
	def isObserverType(Type it) { EcoreUtil.equals(it, observerType) }
	def isSimpleObserverType(Type it) { EcoreUtil.equals(it, simpleObserverType) }
	
	def observableTypeNext() {
		observableType.features.filter(Operation).findFirst[name == "next"]
	}
	
	def simpleObserverTypeSubscribe() {
		simpleObserverType.features.filter(Operation).findFirst[name == "subscribe"]
	}
	
	def referencesReactiveTypes(EObject it) {
		it.eAllContents
			.filter(TypeSpecifier)
			.exists[type.isObservableType || type.isObservableType || type.isSimpleObserverType]
	}
}