package com.itemis.create.base.model.components

import com.google.inject.Inject
import com.google.inject.Injector
import com.google.inject.Singleton
import com.yakindu.base.types.AnnotationType
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.libraries.ITypeLibrary
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.resource.impl.ResourceImpl

@Singleton
class ComponentsTypeLibrary implements ITypeLibrary {

	public static val COMPONENTS_LIBRARY = "create.components"
	public static val COMPONENTS_LIBRARY_URI = URI.createURI(COMPONENTS_LIBRARY)

	public static val CREATE_PACKAGE_NAME = "create"
	public static val COMPONENTS_PACKAGE_NAME = CREATE_PACKAGE_NAME + ".components"
	
	public static val REQUIRES_NAME = "requires"
	public static val PROVIDES_NAME = "provides"
	
	
	@Inject extension TypeBuilder

	var Package typesPackage;

	val resource = new ResourceImpl(ComponentsTypeLibrary.COMPONENTS_LIBRARY_URI) {
		override protected doUnload() {
			// Do no unload in memory resource
		}
	}

	def protected create() {
		typesPackage = createTypesPackage
		resource.URI = ComponentsTypeLibrary.COMPONENTS_LIBRARY_URI
		resource.contents += typesPackage
	}

	def getTypesPackage() {
		if (typesPackage === null) {
			create();
		}
		return typesPackage
	}

	def getResource() {
		getTypesPackage
		resource
	}
	
	
	def getRequires() {
		getTypesPackage().member.findFirst[name == REQUIRES_NAME] as AnnotationType
	}
	
	def getProvides() {
		getTypesPackage().member.findFirst[name == PROVIDES_NAME] as AnnotationType
	}


	protected def createTypesPackage() {
		COMPONENTS_PACKAGE_NAME._package  => [ package |
			package.member += _annotationType(REQUIRES_NAME)
			package.member += _annotationType(PROVIDES_NAME)
		]
	}

	
	override getLibraryPackage() {
		return getTypesPackage
	}
	
	override getLibraryURI() {
		return COMPONENTS_LIBRARY_URI
	}

	static class Provider implements ITypeLibraryProvider {
		
		@Inject Injector injector
		
		override provide() {
			
			val componentsLibrary = injector.getInstance(ComponentsTypeLibrary)
			#[ componentsLibrary ]
		}
		
	}
}
