/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.scxml.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Type
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseExpressionExtensions
import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExitExpression
import com.yakindu.sctunit.sCTUnit.ProceedExpression
import org.eclipse.emf.ecore.EObject

class InterpreterExpressionExtensions extends BaseExpressionExtensions {

	@Inject extension InterpreterNamingExtensions

	def dispatch CharSequence code(EnterExpression it) {
		'''interpreter.enter()'''
	}

	def dispatch CharSequence code(ExitExpression it) {
		'''interpreter.exit()'''
	}

	override dispatch CharSequence code(EventRaisingExpression it) {
		'''raiseEvent("«event.getEvent.eventName»"«IF value !== null», «value.code»«ENDIF»)'''
	}

	override dispatch CharSequence code(ActiveStateReferenceExpression it) {
		'''isStateActive("«value.name»")'''
	}

	protected def dispatch Event getEvent(Expression it) {
		return null
	}

	protected def dispatch Event getEvent(ElementReferenceExpression it) {
		if (reference instanceof Event) {
			return reference as Event
		}
		return null
	}

	protected def dispatch Event getEvent(FeatureCall it) {
		if (feature instanceof Event) {
			return feature as Event
		}
		return null
	}

	override generateNotLocalAssignment(AssignmentExpression it) {
		var type = varRef.infer.type
		if (operator.name().equalsIgnoreCase("assign"))
			return '''«type.varSetter»("«varRef.variableName»", «expression.code»)'''
		else
			return '''«type.varSetter»("«varRef.variableName»", «varRef.code» «operator.toString» «expression.code»)'''
	}

	def CharSequence varSetter(Type type) {
		switch type.name.toLowerCase {
			case 'integer': '''setInteger'''
			case 'boolean': '''setBoolean'''
			case 'string': '''setString'''
			case 'real': '''setDouble'''
			default: '''unknown type'''
		}
	}

	def dispatch CharSequence variableName(ElementReferenceExpression it) {
		'''«referenceName»'''
	}

	def dispatch CharSequence variableName(VariableDefinition it) {
		'''«type?.name»'''
	}

	def dispatch variableName(EObject it) {
		'''unkonwn type'''
	}

	override proceedTime(ProceedExpression it) {
		'''proceedTime(«value.code»);'''
	}
	
	override proceedCycles(ProceedExpression it) {
		'''runCycle();'''
	}
	
}
	