/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.scxml.extensions

import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.base.types.Event
import org.eclipse.xtext.EcoreUtil2
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class InterpreterNamingExtensions extends BaseNamingExtensions {

	def superClassName() {
		'''AbstractExecutionFlowTest'''
	}

	def getEventName(Event it) {
		var scope = EcoreUtil2.getContainerOfType(it, typeof(Scope))
		return eventNameByScope(scope)
	}

	def protected dispatch eventNameByScope(Event it, Scope scope) {}

	def protected dispatch eventNameByScope(Event it, InterfaceScope scope) {
		if (!scope.name.nullOrEmpty)
			return '''«scope.name».«name»'''
		return '''«name»'''
	}

	def protected dispatch eventNameByScope(Event it, InternalScope scope) {
		return '''«name»'''
	}
}
