/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.scxml.qt.extensions

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess

import static com.yakindu.base.types.typesystem.ITypeSystem.*

class QtTypeSystemAccess implements ICodegenTypeSystemAccess {

	@Inject protected extension ITypeSystem

	override getTargetLanguageName(Type type) {
		val originalType = type?.originType
		switch (originalType) {
			case originalType === null || isSame(originalType, getType(VOID)): 'void'
			case isSame(originalType, getType(INTEGER)): 'int'
			case isSame(originalType, getType(REAL)): 'double'
			case isSame(originalType, getType(BOOLEAN)): 'bool'
			case isSame(originalType, getType(STRING)): 'const QString&'
			default: throw new IllegalArgumentException("Target language name could not be inferred for type " + type)
		}
	}

	override getTargetLanguageName(TypeSpecifier typeSpecifier) {
		return getTargetLanguageName(typeSpecifier?.type)
	}

}
