/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.extensions.TypedRxCExtensions
import com.yakindu.sct.generator.c.files.MetaHeader
import com.yakindu.sct.generator.c.files.MetaSource
import com.yakindu.sct.generator.c.files.RxCHeader
import com.yakindu.sct.generator.c.files.RxCSource
import com.yakindu.sct.generator.c.files.StatemachineHeader
import com.yakindu.sct.generator.c.files.StatemachineRequiredHeader
import com.yakindu.sct.generator.c.files.StatemachineSource
import com.yakindu.sct.generator.c.files.StatemachineTypeHeader
import com.yakindu.sct.generator.c.files.StatemachineTypeSource
import com.yakindu.sct.generator.c.files.TimerServiceHeader
import com.yakindu.sct.generator.c.files.TimerServiceSource
import com.yakindu.sct.generator.c.files.Tracing
import com.yakindu.sct.generator.c.files.TypedRxCHeader
import com.yakindu.sct.generator.c.files.TypedRxCSource
import com.yakindu.sct.generator.c.files.Types
import com.yakindu.sct.generator.core.IExecutionFlowGenerator
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations.GenArtifactConfiguration
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.Set
import org.eclipse.xtext.generator.IFileSystemAccess

import static com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess.*
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations.GenArtifactConfiguration
import com.yakindu.sct.generator.core.artifacts.IContentTemplate

/**
 * This is the C code generators main class. 
 * 
 * @author Axel Terfloth
 */
class CGenerator implements IExecutionFlowGenerator {

	@Inject extension Types types
	@Inject extension Tracing tracing
	@Inject extension TimerServiceHeader timerServiceHeader
	@Inject extension TimerServiceSource timerServiceSource
	@Inject extension RxCHeader rxcHeader
	@Inject extension RxCSource rxcSource
	@Inject extension StatemachineHeader statemachineHeader
	@Inject extension StatemachineSource statemachineSource
	@Inject protected extension StatemachineTypeHeader statemachineTypeHeader
	@Inject protected extension StatemachineTypeSource statemachineTypeSource
	@Inject extension StatemachineRequiredHeader statemachineRequiredHeader
	@Inject extension MetaHeader scMetaHeader
	@Inject extension MetaSource scMetaSource
	@Inject extension SExecExtensions
	@Inject extension GenmodelEntries
	@Inject extension Naming
	@Inject extension FileNaming
	@Inject extension ICoreLibraryHelper
	@Inject protected Set<IncludeProvider> includeProviders
	@Inject extension TypedRxCExtensions
	@Inject extension StatemachineTypes
	

	@Inject
	IGenArtifactConfigurations configs
	@Inject AddTimeTypeCastToScheduleTimeEventModification addTimeTypeCastToScheduleTimeEvent

	override generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
		
		addTimeTypeCastToScheduleTimeEvent.modify(flow)
		
		initGenerationArtifacts(flow, entry, configs)
		generateArtifacts(flow, entry, fsa, configs)
	}

	def generateArtifacts(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa,
		IGenArtifactConfigurations locations) {
		for (GenArtifactConfiguration a : locations.configurations) {
			if (!a.skip) {
				fsa.generateFile(a.getName, a.getOutputName, a.getArtifact.fileContent(flow, entry, locations))
			}
		}
	}

	def protected initGenerationArtifacts(ExecutionFlow it, GeneratorEntry entry,
		IGenArtifactConfigurations locations) {
		locations.configure(typesModule.h, entry.libraryOutput, types, getSkipLibraryFiles(entry))
		locations.configure(flow.module.h, entry.headerOutput, statemachineHeader)
		locations.configure(flow.module.c, entry.sourceOutput, statemachineSource)
		if (flow.timed || !flow.operations.empty || entry.tracingUsed) {
			locations.configure(flow.module.client.h, entry.headerOutput, statemachineRequiredHeader)
		}
		if (entry.tracingGeneric) {
			locations.configure(tracingModule.h, entry.libraryOutput, tracing, getSkipLibraryFiles(entry))
		}
		if (entry.outEventObservablesUsed && hasOutgoingEvents) {
			for(payloadType : payloadTypes) {
				locations.configure(payloadType.typedRxcModule.h, entry.libraryOutput,  new TypedRxCHeader(payloadType, _naming, _fileNaming, _genmodelEntries, includeProviders), getSkipLibraryFiles(entry))
				locations.configure(payloadType.typedRxcModule.c, entry.libraryOutput,  new TypedRxCSource(payloadType, _naming, _fileNaming, _genmodelEntries), getSkipLibraryFiles(entry))
			}
			locations.configure(rxcModule.h, entry.libraryOutput, rxcHeader, getSkipLibraryFiles(entry))
			locations.configure(rxcModule.c, entry.libraryOutput, rxcSource, getSkipLibraryFiles(entry))
			
		}
		if (entry.timerService) {
			locations.configure(timerServiceModule.h, entry.libraryOutput, timerServiceHeader, getSkipLibraryFiles(entry))
			locations.configure(timerServiceModule.c, entry.libraryOutput, timerServiceSource, getSkipLibraryFiles(entry))
		}
		if (entry.metaSource) {
			locations.configure(metaModule.h, entry.headerOutput, scMetaHeader, getSkipLibraryFiles(entry))
			locations.configure(metaModule.c, entry.headerOutput, scMetaSource, getSkipLibraryFiles(entry))
		}
		
		if(!declaredInternalStatemachineTypes.nullOrEmpty){
			locations.configure(statemachineModule.h, entry.libraryOutput, statemachineTypeHeader, getSkipLibraryFiles(entry))
			locations.configure(statemachineModule.c, entry.libraryOutput, statemachineTypeSource, getSkipLibraryFiles(entry))
		}
	}

	def protected getHeaderOutput(GeneratorEntry entry) {
		if (entry.apiTargetFolderValue !== null) {
			API_TARGET_FOLDER_OUTPUT
		} else {
			TARGET_FOLDER_OUTPUT
		}
	}

	def protected getLibraryOutput(GeneratorEntry entry) {
		if (entry.libraryTargetFolderValue !== null) {
			LIBRARY_TARGET_FOLDER_OUTPUT
		} else {
			entry.headerOutput
		}
	}

	def protected getSourceOutput(GeneratorEntry entry) {
		TARGET_FOLDER_OUTPUT
	}

	def dispatch String fileContent(IContentTemplate<ExecutionFlow> it, ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		it.content(flow, entry, locations)
	}
	
	def dispatch String fileContent(Object it, Object p, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		""
	}

}
