/**
  Copyright (c) 2014-2022 committers of itemis CREATE.
  All rights reserved. This program and the accompanying materials
  are made available under the terms of the Eclipse Public License v1.0
  which accompanies this distribution, and is available at
  http://www.eclipse.org/legal/epl-v10.html
  
  Contributors:
  	Markus Mühlbrandt - Initial contribution and API
*/

package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.DefaultNamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgen.GeneratorModel
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.Statechart
import java.util.Arrays
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.yakindu.sct.generator.c.CKeywords.*

@Singleton
class CNamingService extends DefaultNamingService {
	
	@Inject
	extension GenmodelEntries
	@Inject
	extension SExecExtensions
	@Inject
	var GeneratorEntry entry
	
	def protected calculatePrefix(Statechart statechart){
		var prefix = ""
		val genModel = entry.eContainer as GeneratorModel
		for (entrie : genModel.entries) {
			if(EcoreUtil.equals(entrie.elementRef,statechart) && !entrie.statemachinePrefix.nullOrEmpty) prefix = entrie.statemachinePrefix
		}
		prefix
	}
	
	def protected calculateSeparator(Statechart statechart){
		val genModel = entry.eContainer as GeneratorModel
		genModel.entries.forEach[entrie | 
			if(EcoreUtil.equals(entrie.elementRef,statechart) && entrie.separator !== null) separator = entrie.separator.charAt(0)
		]			
	}
	
	override protected dispatch void initializeRow(Statechart statechart) {
		statechart.calculateSeparator
		
		super._initializeRow(statechart)
	}
	
	override protected dispatch void initializeRow(ExecutionFlow flow) {
		flow.statechart.calculateSeparator
		
		super._initializeRow(flow)
	}
	
	
	override protected prefix(Step it, char separator) {
		switch (it) {
			case isCheckFunction: "check"
			case isEntryAction: "enact"
			case isExitAction: "exact"
			case isEffect: "effect"
			case isEnterSequence: "enseq"
			case isDeepEnterSequence: "dhenseq"
			case isShallowEnterSequence: "shenseq"
			case isExitSequence: "exseq"
			case isReactSequence: "react"
			default: ""
		}
	}
	
	override protected prefix(ExecutionState it, char separator) {
		if ((flow.sourceElement as Statechart).calculatePrefix.nullOrEmpty) {
			super.prefix(it, separator).toFirstUpper			
		} else {
			(flow.sourceElement as Statechart).calculatePrefix
		}
	}
	
	override protected prefix(RegularState it, char separator) {
		if (statechart.calculatePrefix.nullOrEmpty) {
			super.prefix(it, separator).toFirstUpper
		} else {
			statechart.calculatePrefix
		}
	}
	
	override protected prefix(TimeEventSpec it, NamedElement element, char separator) {
		if (statechart.calculatePrefix.nullOrEmpty) {
			super.prefix(it, element, separator).toFirstLower
		} else {
			statechart.calculatePrefix
		}
	}
	
	override asEscapedIdentifier(String it) {
		var s = it
		if (s.isKeyword) {
			s = s + separator +'ID'
		}
		return s.asIdentifier
	}
	
	override boolean isKeyword(String name) {
		return !Arrays::asList(C_KEYWORDS).findFirst[it.equalsIgnoreCase(name)].nullOrEmpty
	}
	
	override protected dispatch String elementName(Method it) {
		var string = name
		if(string == "") return ""
		return string.split("\\.").join("",[toString.toFirstUpper]).replaceAll("(\\p{Lower})(\\p{Upper})", "$1_$2").replaceAll("\\^", "\\_").toLowerCase();
	}
	
}