/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.library.impl.DefaultCoreLibraryHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.ExecutionDebugging
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.List

/**
 * This class is responsible to provide the include for the Logger implementation 
 * if the execution debugging is defined either on the statechart or via generator feature
 * 
 * @author laszlo kovacs - Initial contribution
 */
class LoggerIncludeProvider implements IncludeProvider {
	@Inject extension GeneratorEntry entry
	@Inject protected extension DefaultCoreLibraryHelper
	@Inject protected extension ExecutionDebugging
	@Inject protected extension FileNaming

	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		val List<CharSequence> includes = newArrayList
		if (appliesDebugExecution || entry.debugExecution) {
			includes.add('''#include "«(loggerModule.h).relativeTo(module.h)»"''')
		}
		includes
	}
}
