/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.concepts

import com.google.inject.Singleton
import com.yakindu.base.types.TypesFactory
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.transformation.MapTimeEventValue

/**
 * Translates the default 'integer' type usage for the time event scheduler method to 'sc_time' type.
 * 
 * @author laszlo kovacs - Initial contribution
 */
@Singleton
class CMapTimeEventValue extends MapTimeEventValue{
	
	extension TypesFactory tFactory = TypesFactory.eINSTANCE
	
	override declareReactMethod(ExecutionFlow node, TimeEvent te) {
		node => [
			features.add(te.scheduleTimeValue)
			
			features.add(te.defineReactMethod => [ m |
				val value = m.param('value')
				value.typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = timeType
				]
				m.typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = timeType
				]
			])
		]
	}
	
	def protected create  tt : createType  timeType() {
		tt.name = "sc_time"
	}
}