/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.ISourceFragment
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.List

class StatemachineSource implements IContentTemplate<ExecutionFlow> {
	@Inject protected extension INamingService

	val protected List<ISourceFragment> contentProviders = newArrayList();
		
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) { 
		initializeNamingService
		
		'''
		«fileComment(entry, artifactConfigs)»
		
		«includes(entry, artifactConfigs)»
		
		«declarations(entry, artifactConfigs)»
		
		«implementations(entry, artifactConfigs)»
		'''
	}
	
	def CharSequence fileComment(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		«FOR p : contentProviders»
		«p.fileComment(it, entry, artifactConfigs)»
		«ENDFOR»
		'''
	}
	
	def CharSequence includes(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		«FOR p : contentProviders»
		«p.includes(it, entry, artifactConfigs)»
		«ENDFOR»
		'''
	}
	
	def CharSequence declarations(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		«FOR p : contentProviders»
		«p.declarations(it, entry, artifactConfigs)»
		«ENDFOR»
		'''
	}
	
	def CharSequence implementations(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		«FOR p : contentProviders»
		«p.implementations(it, entry, artifactConfigs)»
		«ENDFOR»
		'''
	}
	
	def getContentProviders() {
		return contentProviders
	}
	
	

}