package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.base.types.Operation
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgen.GeneratorEntry

class StatemachineTypeSource implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension GenmodelEntries
	@Inject protected extension Naming
	@Inject protected extension FileNaming
	@Inject protected extension StatemachineTypes
	@Inject protected extension ITypeSystem
	
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#include "«(statemachineModule.h)»"
		
		«FOR t : flow.declaredInternalStatemachineTypes»
			«FOR f : t.getAllFeatures.filter(Operation)»
				«IF f.eContainer == t»
				«f.type.cType» sc_«f.name»(«t.structName»_t *machine_){
					«IF !f.type.isVoid»return «ENDIF»machine_->«f.name»(machine_->«IF !t.superTypes.nullOrEmpty»statemachine_type.«ENDIF»machine);
				}
				«ENDIF»
			«ENDFOR»
		«ENDFOR»		
		'''
	}
}