/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.TypesUtil
import com.yakindu.sct.generator.c.FlowCode
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CLiterals
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EnterMethod
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.ExecutionGuard
import com.yakindu.sct.model.sexec.concepts.ExitMethod
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.InterfaceScope

import static com.yakindu.sct.generator.c.CGeneratorConstants.*
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * @author rbeckmann
 * @author Axel Terfloth - terfloth@itemis.de 
 * 
 */
@Singleton
class APIGenerator {
	@Inject protected extension FlowCode
	@Inject protected extension INamingService
	@Inject protected extension Naming
	@Inject protected extension CTypes
	@Inject protected extension SExecExtensions
	@Inject protected extension StateVectorExtensions
	@Inject protected extension Literals
	@Inject protected extension StatechartAnnotations
	@Inject protected extension GeneratorPredicate
	@Inject protected extension TraceCode
	@Inject protected extension GeneratorEntry genEntry
	@Inject protected extension GenmodelEntries
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension InternalFunctionsGenerator
	@Inject protected extension EventNaming

	@Inject protected extension EnterMethod
	@Inject protected extension ExitMethod
	@Inject protected extension RunCycleMethod
	@Inject protected extension ExecutionGuard
	@Inject protected extension EventProcessing
	@Inject protected extension TypesUtil

	def tracing(ExecutionFlow it) {
		if (timed)
			'''
				static «sc_integer.name» time_event_index(«scHandleDecl», «sc_eventid.name» evid)
				{
					«sc_intptr.name» offset = («sc_intptr.name»)evid - («sc_intptr.name»)&(handle->timeEvents);
					«sc_intptr.name» tev_id = offset / («sc_intptr.name»)sizeof(sc_boolean);
					return («sc_integer.name»)tev_id;
				}
			'''
		else
			''''''
	}

	def initWithTracing(ExecutionFlow it) {
		'''
			«initWithTracingSignature»
			{
				«initFunctionBody(it)»
			}
		'''
	}

	def init(ExecutionFlow it) {
		'''
			«initSignature»
			{
				«IF genEntry.tracingGeneric»
					«initTracingFctID»(«scHandle», «CLiterals::NULL_LITERAL_NAME»);
				«ELSE»
					«initFunctionBody(it)»
				«ENDIF»
			}
		'''
	}

	protected def CharSequence initFunctionBody(ExecutionFlow it) {
		'''
			«sc_integer.name» i;
			
			for (i = 0; i < «maxOrthogonalStates»; ++i)
			{
				«scHandle»->«STATEVECTOR»[i] = «null_state»;
			}
			
			«IF hasHistory»
				for (i = 0; i < «maxHistoryStates»; ++i)
				{
					«scHandle»->«HISTORYVECTOR»[i] = «null_state»;
				}
			«ENDIF»
						
			«_clearInEvents.code»
			«_clearInternalEvents.code»
			«_swapIncomingEvents.code»
			«_swapInternalEvents.code»
			«_clearOutEvents.code»
			
			«IF useOutEventObservables»
				«initializeObservables»
			«ENDIF»
			«initializeObserver»
			
			«IF genEntry.tracingGeneric»
				«scHandle»->trace_handler = trace_handler;
				«traceConstants»
			«ENDIF»
			«nullInitializeShadowEventVariablePointers»
			«initSequence.code»
			
			«_initIsExecuting.code»
		'''
	}

	def traceConstants(ExecutionFlow it) {
		'''
			«FOR constant : constants»
				«constant.notifyTrace»
			«ENDFOR»
		'''
	}

	protected def nullInitializeShadowEventVariablePointers(ExecutionFlow it) {
		'''
			«FOR scope : interfaceScopes + internalScopes»
				«FOR variable : scope.variables»
					«IF !variable.const && variable.needsShadowEventMapping»
						«variable.access» = «NULL_LITERAL»;
					«ENDIF»
				«ENDFOR»
			«ENDFOR»
		'''
	}

	protected def CharSequence initializeObserver(ExecutionFlow it) {
		'''
			«FOR e : shadowEvents»
				sc_single_subscription_observer«e.eventType»_init(&(«e.accessObserver»), «scHandle», («e.functionType»)«e.observerCallbackFctID»);
			«ENDFOR»
		'''
	}

	def private functionType(Event it) {
		if (hasValue) {
			return '''sc_observer_next«eventType»_fp'''
		}
		return sc_observer_next_fp.name
	}

	def initializeObservables(ExecutionFlow it) {
		'''
			«FOR outEvent : scopes.filter(InterfaceScope).map[events].flatten.filter[direction === Direction.OUT]»
				sc_observable«outEvent.eventType»_init(&«outEvent.accessObservable»);
			«ENDFOR»
		'''
	}

	def protected CharSequence initSignature(ExecutionFlow it) {
		'''void «initFctID»(«scHandleDecl»)'''
	}

	def declareInit(ExecutionFlow it) {
		'''«initSignature»;'''
	}

	def isActive(ExecutionFlow it) {
		'''
			«isActiveSignature»
			{
				«sc_bool.name» result = «FALSE_LITERAL»;
				«sc_integer.name» i;
				
				for(i = 0; i < «maxOrthogonalStates»; i++)
				{
					result = result || «scHandle»->«STATEVECTOR»[i] != «null_state»;
				}
				
				return result;
			}
		'''
	}

	def declareIsActive(ExecutionFlow it) {
		'''«isActiveSignature»;'''
	}

	def protected CharSequence isActiveSignature(ExecutionFlow it) {
		'''«sc_bool.name» «isActiveFctID»(const «scHandleDecl»)'''
	}

	def isStateActive(ExecutionFlow it) {
		'''
			«isStateActiveSignature»
			{
				«sc_bool.name» result = «FALSE_LITERAL»;
				switch (state)
				{
					«FOR s : states»
						case «s.stateName» :
							result = («sc_bool.name») («IF s.leaf»«scHandle»->«STATEVECTOR»[«s.stateVectorDefine»] == «s.stateName»
							«ELSE»«scHandle»->«STATEVECTOR»[«s.stateVectorDefine»] >= «s.stateName»
								&& «scHandle»->«STATEVECTOR»[«s.stateVectorDefine»] <= «s.subStates.lastOrNull.stateName»«ENDIF»);
								break;
						«ENDFOR»
						default:
							result = «FALSE_LITERAL»;
							break;
					}
					return result;
				}
			'''
	}

	def declareIsStateActive(ExecutionFlow it) {
		'''«isStateActiveSignature»;'''
	}

	def protected CharSequence isStateActiveSignature(ExecutionFlow it) {
		'''«sc_bool.name» «stateActiveFctID»(const «scHandleDecl», «statesEnumType» state)'''
	}

	def isFinal(ExecutionFlow it) {
		val fsiv = flow.finalStateImpactVector

		'''
			«IF !fsiv.isCompletelyCovered»
				/* 
				 * Always returns 'false' since this state machine can never become final.
				 */
			«ENDIF»
			«isFinalSignature»
			{
				«IF (fsiv.isCompletelyCovered)»
					return 
					«FOR i : 0 ..<fsiv.size SEPARATOR ' && '»(
							«FOR fs : fsiv.get(i) SEPARATOR ' || '»
								«scHandle»->«STATEVECTOR»[«i»] == «IF fs.stateVector.offset == i»«fs.stateName»«ELSE»«null_state»«ENDIF»
							«ENDFOR»)
					«ENDFOR»;
				«ELSE»
					«unusedParam(scHandle)»
					return «FALSE_LITERAL»;
				«ENDIF»
			}
		'''
	}

	def declareIsFinal(ExecutionFlow it) {
		'''«isFinalSignature»;'''
	}

	def protected CharSequence isFinalSignature(ExecutionFlow it) {
		'''«sc_bool.name» «isFinalFctID»(const «scHandleDecl»)'''
	}

	def raiseTimeEvent(ExecutionFlow it) {
		'''
			«raiseTimeEventSignature»
			{
				if ( ((«sc_intptr.name»)evid) >= ((«sc_intptr.name»)&(«scHandle»->timeEvents))
					&&  ((«sc_intptr.name»)evid) < ((«sc_intptr.name»)&(«scHandle»->timeEvents)) + («sc_intptr.name»)sizeof(«timeEventScope.type»))
					{
					*(«sc_bool.name»*)evid = «TRUE_LITERAL»;
					«traceTimeEventRaised»
				}
			}
		'''
	}

	def declareRaiseTimeEvent(ExecutionFlow it) {
		'''«raiseTimeEventSignature»;'''
	}

	def protected CharSequence raiseTimeEventSignature(ExecutionFlow it) {
		'''void «raiseTimeEventFctID»(«scHandleDecl», «sc_eventid.name» evid)'''
	}

	def declareInitWithTracing(ExecutionFlow it) {
		'''«initWithTracingSignature»;'''
	}

	def protected CharSequence initWithTracingSignature(ExecutionFlow it) {
		'''void «initTracingFctID»(«scHandleDecl», «scTracingHandleDecl»)'''
	}

	def declareSetTraceHandler(ExecutionFlow it) {
		'''«setTraceHandlerSignature»;'''
	}

	def protected CharSequence setTraceHandlerSignature(ExecutionFlow it) {
		'''void «setTraceHandlerFctID»(«scHandleDecl», «scTracingHandleDecl»)'''
	}

}
