/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.c.FlowCode
import com.yakindu.sct.generator.c.codepattern.MethodCode
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.naming.INamingService

/**
 * Generator module that cares about generically generating methods defined in the 
 * execution flow.
 * 
 * @author axel terfloth
 */
class MethodGenerator {

	@Inject protected extension INamingService
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension Naming
	@Inject protected extension MethodCode	
	@Inject protected extension FlowCode


	def declarations(Iterable<Operation> steps) '''
		«FOR s : steps»
			«s.declaration»
		«ENDFOR»
	'''
	
	
	def dispatch declaration(Method it) '''
		«IF ! body.comment.isNullOrEmpty»/*! «body.comment» */«ENDIF»
		«declarationModifier»«typeSpecifier.targetLanguageName» «methodShortName»(«scHandleDecl»«FOR p : parameters BEFORE ', ' SEPARATOR ', '»«IF p.varArgs»...«ELSE»const «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR»);
		
	'''
	
	def dispatch declaration(Operation it) '''
		«methodDeclarationCode»
	'''
	
	

	def implementation(Iterable<Operation> methods) '''
	 	«FOR m : methods»
	 		«m.definition»
	 		
	 	«ENDFOR»
	'''
	
	def dispatch definition(Method it) '''
		«implementationModifier»«typeSpecifier.targetLanguageName» «methodShortName»(«scHandleDecl»«FOR p : parameters BEFORE ', ' SEPARATOR ', '»«IF p.varArgs»...«ELSE»const «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR»)
		{
			«IF !body.steps.nullOrEmpty»«body.stepComment»«ENDIF»
 			«body.steps.filter(LocalVariableDefinition).map[s | s.code].join»
			«IF !body.requiresHandles»
				«unusedParam(scHandle)»
			«ENDIF»
			«body.steps.filter[s | !(s instanceof LocalVariableDefinition)].map[s | s.code].join»
		}
	'''
	
	def dispatch definition(Operation it) '''
		«methodDefinitionCode»
	'''
	
}