/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules.eventdriven

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.submodules.APIGenerator
import com.yakindu.sct.generator.c.submodules.TraceCode
import com.yakindu.sct.generator.c.types.CLiterals
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

/**
 * @author rbeckmann
 * @author axel terfloth
 *
 */
@Singleton // Guice
class EventDrivenAPIGenerator extends APIGenerator {
	@Inject protected extension EventQueue
	@Inject protected extension EventNaming
	@Inject protected extension Literals
	@Inject protected extension CTypes
	@Inject protected extension TraceCode
	
	override protected initSignature(ExecutionFlow it) {
		'''void «initFctID»(«scHandleDecl»«userAllocatedQueueArgs»)'''
	}
	
	protected def userAllocatedQueueArgs(ExecutionFlow it) {
		val internalArgs = ''', «internalEventStructTypeName» *internal_queue_buffer, «sc_integer.name» internal_queue_capacity'''
		val inArgs = ''', «internalEventStructTypeName» *in_queue_buffer, «sc_integer.name» in_queue_capacity'''
		'''«IF userAllocatesInternalQueue»«internalArgs»«ENDIF»«IF userAllocatesInQueue»«inArgs»«ENDIF»'''
	}
	
	override protected initFunctionBody(ExecutionFlow it) {
		'''
		«super.initFunctionBody(it)»
		«IF requiresInternalEventQueue»
			«eventQueueInitFunction»(&«scHandle»->«internalQueue», «IF userAllocatesInternalQueue»internal_queue_buffer, internal_queue_capacity«ELSE»«scHandle»->internal_buffer, «internalBufferSize»«ENDIF»);
		«ENDIF»
		«IF requiresIncomingEventQueue»
			«eventQueueInitFunction»(&«scHandle»->«inEventQueue», «IF userAllocatesInQueue»in_queue_buffer, in_queue_capacity«ELSE»«scHandle»->in_buffer, «inBufferSize»«ENDIF»);
		«ENDIF»
		'''
	}
	
	override protected initWithTracingSignature(ExecutionFlow it) {
		'''void «initTracingFctID»(«scHandleDecl»«userAllocatedQueueArgs», «scTracingHandleDecl»)'''
	}
	
	override init(ExecutionFlow it) {
		'''
			«initSignature»
			{
				«IF genEntry.tracingGeneric»
				«initTracingFctID»(«scHandle»«IF userAllocatesInternalQueue», internal_queue_buffer, internal_queue_capacity«ENDIF»«IF userAllocatesInQueue», in_queue_buffer, in_queue_capacity«ENDIF», «CLiterals::NULL_LITERAL_NAME»);
				«ELSE»
				«initFunctionBody(it)»
				«ENDIF»
			}
		'''
	}

		
	override raiseTimeEvent(ExecutionFlow it) '''
		«IF timed»
			«raiseTimeEventSignature»
			{
				if ( ((«sc_intptr.name»)evid) >= ((«sc_intptr.name»)&(«scHandle»->timeEvents))
					&&  ((«sc_intptr.name»)evid) < ((«sc_intptr.name»)&(«scHandle»->timeEvents)) + («sc_intptr.name»)sizeof(«timeEventScope.type»))
				{
					«IF requiresIncomingEventQueue»
					«addToQueueFctID»(&(«scHandle»->«inEventQueue»), «timedEventNameFctID»(«scHandle», evid));
					«ELSE»
					*(«sc_bool.name»*)evid = «TRUE_LITERAL»;
					«ENDIF»
					«traceTimeEventRaised»
					«runCycleFctID»(«scHandle»);
				}
			}
		«ENDIF»
		'''
	
}