/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.types

/**
 * This class provides names of the built in primitive C types which are used by the SCT code generators.
 * As such types provided by this extension provide implementation type information which is not covered by the SCT model type system.
 * Subclasses can overwrite and and contribute other names which then will be used throughout the code generation.
 * Also C++ type names will be contributed this way.
 * 
 * @author axel terfloth - Initial contribution.
 */
class CTypes {
	
	public static final CTypes.PType SC_VOID = new PVoid("void")
	public static final CTypes.PType SC_STRING = new CString("sc_string")
	public static final CTypes.PType SC_INTEGER = new PNumber("sc_integer")
	public static final CTypes.PType SC_REAL= new PNumber("sc_real")
	public static final CTypes.PType SC_BOOL= new PBoolean("sc_boolean")
	public static final CTypes.PType SC_UINTEGER = new PNumber("sc_uinteger")

	public static final CTypes.PType SC_SHORT = new PNumber("sc_short")
	public static final CTypes.PType SC_USHORT = new PNumber("sc_ushort")
	public static final CTypes.PType SC_ERROR = new PNumber("sc_errorCode")
	public static final CTypes.PType SC_EVENTID = new PNumber("sc_eventid")
	public static final CTypes.PType SC_INTPTR = new PNumber("sc_intptr_t")
	public static final CTypes.PType SC_TIME = new PNumber("sc_time")
	
	public static final CTypes.PType SC_OBSERVABLE = new PType("sc_observable")
	public static final CTypes.PType SC_OBSERVER = new PType("sc_observer")
	public static final CTypes.PType SC_SINGLE_SUBSCRIPTION_OBSERVER = new PType("sc_single_subscription_observer")
	public static final CTypes.PType SC_OBSERVER_NEXT_FP = new PType("sc_observer_next_fp")
	public static final CTypes.PType SC_NULL = new PVoid("sc_null")
		
	
	public static final CTypes.PType TYPES_MODULE = new PType("sc_types")
	

	/**
	 * Simple representation which contains name and potentially namespace of single types. 
	 */
	static class PType {
		protected String name
		protected String nameSpace
		
		new (String name) {
			this(null, name)
		}
		
		new (String nameSpace, String name) {
			this.name = name
			this.nameSpace = nameSpace
		}
		
		def name() {
			name
		}
		
		def fqName() {
			return	if (nameSpace !== null) 
						nameSpace + "::" + name 
					else 
						name
		}
	}

	static class PVoid extends CTypes.PType {
	
		new(String name) {
			super(name)
		}
		
		new(String nameSpace, String name) {
			super(nameSpace, name)
		}	
	}
	

	static class PString extends CTypes.PType {
	
		new(String name) {
			super(name)
		}
		
		new(String nameSpace, String name) {
			super(nameSpace, name)
		}	
	}
	
	static class CString extends PString {
	
		new(String name) {
			super(name)
		}
		
		new(String nameSpace, String name) {
			super(nameSpace, name)
		}
	
	}
	
	static class PNumber extends CTypes.PType {
	
		new(String name) {
			super(name)
		}
		
		new(String nameSpace, String name) {
			super(nameSpace, name)
		}
		
	}
	
	static class PBoolean extends CTypes.PType {
	
		new(String name) {
			super(name)
		}
		
		new(String nameSpace, String name) {
			super(nameSpace, name)
		}
		
	}
	
	
	def sc_void() { SC_VOID }
	def sc_string() { SC_STRING }
	def sc_string_literal() { SC_STRING }
	def sc_integer() { SC_INTEGER }
	def sc_real() { SC_REAL }
	def sc_bool() { SC_BOOL }
	def sc_short() { SC_SHORT }
	def sc_ushort() { SC_USHORT }
	def sc_error() { SC_ERROR }
	def sc_eventid() { SC_EVENTID }
	def sc_uinteger() { SC_UINTEGER }
	def sc_intptr() { SC_INTPTR }
	def sc_time() { SC_TIME }
	
	def sc_observable() { SC_OBSERVABLE }
	def sc_observer() { SC_OBSERVER }
	def sc_single_subscription_observer() { SC_SINGLE_SUBSCRIPTION_OBSERVER }
	def sc_observer_next_fp() { SC_OBSERVER_NEXT_FP }
	def sc_null() { SC_NULL }
	def sc_types() { TYPES_MODULE }	
	
}