/*
*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
grammar InternalSGen;

options {
	superClass=AbstractInternalContentAssistParser;
	backtrack=true;
}

@lexer::header {
package com.yakindu.sct.generator.genmodel.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package com.yakindu.sct.generator.genmodel.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import com.yakindu.sct.generator.genmodel.services.SGenGrammarAccess;

}
@parser::members {
	private SGenGrammarAccess grammarAccess;

	public void setGrammarAccess(SGenGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleGeneratorModel
entryRuleGeneratorModel
:
{ before(grammarAccess.getGeneratorModelRule()); }
	 ruleGeneratorModel
{ after(grammarAccess.getGeneratorModelRule()); } 
	 EOF 
;

// Rule GeneratorModel
ruleGeneratorModel 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGeneratorModelAccess().getGroup()); }
		(rule__GeneratorModel__Group__0)
		{ after(grammarAccess.getGeneratorModelAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyDefinition
entryRulePropertyDefinition
:
{ before(grammarAccess.getPropertyDefinitionRule()); }
	 rulePropertyDefinition
{ after(grammarAccess.getPropertyDefinitionRule()); } 
	 EOF 
;

// Rule PropertyDefinition
rulePropertyDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getGroup()); }
		(rule__PropertyDefinition__Group__0)
		{ after(grammarAccess.getPropertyDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleGeneratorEntry
entryRuleGeneratorEntry
:
{ before(grammarAccess.getGeneratorEntryRule()); }
	 ruleGeneratorEntry
{ after(grammarAccess.getGeneratorEntryRule()); } 
	 EOF 
;

// Rule GeneratorEntry
ruleGeneratorEntry 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGeneratorEntryAccess().getGroup()); }
		(rule__GeneratorEntry__Group__0)
		{ after(grammarAccess.getGeneratorEntryAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFeatureConfiguration
entryRuleFeatureConfiguration
:
{ before(grammarAccess.getFeatureConfigurationRule()); }
	 ruleFeatureConfiguration
{ after(grammarAccess.getFeatureConfigurationRule()); } 
	 EOF 
;

// Rule FeatureConfiguration
ruleFeatureConfiguration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFeatureConfigurationAccess().getGroup()); }
		(rule__FeatureConfiguration__Group__0)
		{ after(grammarAccess.getFeatureConfigurationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFeatureParameterValue
entryRuleFeatureParameterValue
:
{ before(grammarAccess.getFeatureParameterValueRule()); }
	 ruleFeatureParameterValue
{ after(grammarAccess.getFeatureParameterValueRule()); } 
	 EOF 
;

// Rule FeatureParameterValue
ruleFeatureParameterValue 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFeatureParameterValueAccess().getGroup()); }
		(rule__FeatureParameterValue__Group__0)
		{ after(grammarAccess.getFeatureParameterValueAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleGENERATOR_ID
entryRuleGENERATOR_ID
:
{ before(grammarAccess.getGENERATOR_IDRule()); }
	 ruleGENERATOR_ID
{ after(grammarAccess.getGENERATOR_IDRule()); } 
	 EOF 
;

// Rule GENERATOR_ID
ruleGENERATOR_ID 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGENERATOR_IDAccess().getGroup()); }
		(rule__GENERATOR_ID__Group__0)
		{ after(grammarAccess.getGENERATOR_IDAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpression
entryRuleExpression
:
{ before(grammarAccess.getExpressionRule()); }
	 ruleExpression
{ after(grammarAccess.getExpressionRule()); } 
	 EOF 
;

// Rule Expression
ruleExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall()); }
		ruleAssignmentExpression
		{ after(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression
:
{ before(grammarAccess.getAssignmentExpressionRule()); }
	 ruleAssignmentExpression
{ after(grammarAccess.getAssignmentExpressionRule()); } 
	 EOF 
;

// Rule AssignmentExpression
ruleAssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup()); }
		(rule__AssignmentExpression__Group__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConditionalExpression
entryRuleConditionalExpression
:
{ before(grammarAccess.getConditionalExpressionRule()); }
	 ruleConditionalExpression
{ after(grammarAccess.getConditionalExpressionRule()); } 
	 EOF 
;

// Rule ConditionalExpression
ruleConditionalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getGroup()); }
		(rule__ConditionalExpression__Group__0)
		{ after(grammarAccess.getConditionalExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalOrExpression
entryRuleLogicalOrExpression
:
{ before(grammarAccess.getLogicalOrExpressionRule()); }
	 ruleLogicalOrExpression
{ after(grammarAccess.getLogicalOrExpressionRule()); } 
	 EOF 
;

// Rule LogicalOrExpression
ruleLogicalOrExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup()); }
		(rule__LogicalOrExpression__Group__0)
		{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalAndExpression
entryRuleLogicalAndExpression
:
{ before(grammarAccess.getLogicalAndExpressionRule()); }
	 ruleLogicalAndExpression
{ after(grammarAccess.getLogicalAndExpressionRule()); } 
	 EOF 
;

// Rule LogicalAndExpression
ruleLogicalAndExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup()); }
		(rule__LogicalAndExpression__Group__0)
		{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalNotExpression
entryRuleLogicalNotExpression
:
{ before(grammarAccess.getLogicalNotExpressionRule()); }
	 ruleLogicalNotExpression
{ after(grammarAccess.getLogicalNotExpressionRule()); } 
	 EOF 
;

// Rule LogicalNotExpression
ruleLogicalNotExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getAlternatives()); }
		(rule__LogicalNotExpression__Alternatives)
		{ after(grammarAccess.getLogicalNotExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseOrExpression
entryRuleBitwiseOrExpression
:
{ before(grammarAccess.getBitwiseOrExpressionRule()); }
	 ruleBitwiseOrExpression
{ after(grammarAccess.getBitwiseOrExpressionRule()); } 
	 EOF 
;

// Rule BitwiseOrExpression
ruleBitwiseOrExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup()); }
		(rule__BitwiseOrExpression__Group__0)
		{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXorExpression
entryRuleBitwiseXorExpression
:
{ before(grammarAccess.getBitwiseXorExpressionRule()); }
	 ruleBitwiseXorExpression
{ after(grammarAccess.getBitwiseXorExpressionRule()); } 
	 EOF 
;

// Rule BitwiseXorExpression
ruleBitwiseXorExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup()); }
		(rule__BitwiseXorExpression__Group__0)
		{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseAndExpression
entryRuleBitwiseAndExpression
:
{ before(grammarAccess.getBitwiseAndExpressionRule()); }
	 ruleBitwiseAndExpression
{ after(grammarAccess.getBitwiseAndExpressionRule()); } 
	 EOF 
;

// Rule BitwiseAndExpression
ruleBitwiseAndExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup()); }
		(rule__BitwiseAndExpression__Group__0)
		{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalRelationExpression
entryRuleLogicalRelationExpression
:
{ before(grammarAccess.getLogicalRelationExpressionRule()); }
	 ruleLogicalRelationExpression
{ after(grammarAccess.getLogicalRelationExpressionRule()); } 
	 EOF 
;

// Rule LogicalRelationExpression
ruleLogicalRelationExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalRelationExpressionAccess().getGroup()); }
		(rule__LogicalRelationExpression__Group__0)
		{ after(grammarAccess.getLogicalRelationExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleShiftExpression
entryRuleShiftExpression
:
{ before(grammarAccess.getShiftExpressionRule()); }
	 ruleShiftExpression
{ after(grammarAccess.getShiftExpressionRule()); } 
	 EOF 
;

// Rule ShiftExpression
ruleShiftExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getGroup()); }
		(rule__ShiftExpression__Group__0)
		{ after(grammarAccess.getShiftExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericalAddSubtractExpression
entryRuleNumericalAddSubtractExpression
:
{ before(grammarAccess.getNumericalAddSubtractExpressionRule()); }
	 ruleNumericalAddSubtractExpression
{ after(grammarAccess.getNumericalAddSubtractExpressionRule()); } 
	 EOF 
;

// Rule NumericalAddSubtractExpression
ruleNumericalAddSubtractExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup()); }
		(rule__NumericalAddSubtractExpression__Group__0)
		{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericalMultiplyDivideExpression
entryRuleNumericalMultiplyDivideExpression
:
{ before(grammarAccess.getNumericalMultiplyDivideExpressionRule()); }
	 ruleNumericalMultiplyDivideExpression
{ after(grammarAccess.getNumericalMultiplyDivideExpressionRule()); } 
	 EOF 
;

// Rule NumericalMultiplyDivideExpression
ruleNumericalMultiplyDivideExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup()); }
		(rule__NumericalMultiplyDivideExpression__Group__0)
		{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericalUnaryExpression
entryRuleNumericalUnaryExpression
:
{ before(grammarAccess.getNumericalUnaryExpressionRule()); }
	 ruleNumericalUnaryExpression
{ after(grammarAccess.getNumericalUnaryExpressionRule()); } 
	 EOF 
;

// Rule NumericalUnaryExpression
ruleNumericalUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getAlternatives()); }
		(rule__NumericalUnaryExpression__Alternatives)
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePostFixUnaryExpression
entryRulePostFixUnaryExpression
:
{ before(grammarAccess.getPostFixUnaryExpressionRule()); }
	 rulePostFixUnaryExpression
{ after(grammarAccess.getPostFixUnaryExpressionRule()); } 
	 EOF 
;

// Rule PostFixUnaryExpression
rulePostFixUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPostFixUnaryExpressionAccess().getGroup()); }
		(rule__PostFixUnaryExpression__Group__0)
		{ after(grammarAccess.getPostFixUnaryExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeCastExpression
entryRuleTypeCastExpression
:
{ before(grammarAccess.getTypeCastExpressionRule()); }
	 ruleTypeCastExpression
{ after(grammarAccess.getTypeCastExpressionRule()); } 
	 EOF 
;

// Rule TypeCastExpression
ruleTypeCastExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeCastExpressionAccess().getGroup()); }
		(rule__TypeCastExpression__Group__0)
		{ after(grammarAccess.getTypeCastExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFeatureCall
entryRuleFeatureCall
:
{ before(grammarAccess.getFeatureCallRule()); }
	 ruleFeatureCall
{ after(grammarAccess.getFeatureCallRule()); } 
	 EOF 
;

// Rule FeatureCall
ruleFeatureCall 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup()); }
		(rule__FeatureCall__Group__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression
:
{ before(grammarAccess.getPrimaryExpressionRule()); }
	 rulePrimaryExpression
{ after(grammarAccess.getPrimaryExpressionRule()); } 
	 EOF 
;

// Rule PrimaryExpression
rulePrimaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAlternatives()); }
		(rule__PrimaryExpression__Alternatives)
		{ after(grammarAccess.getPrimaryExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleElementReferenceExpression
entryRuleElementReferenceExpression
:
{ before(grammarAccess.getElementReferenceExpressionRule()); }
	 ruleElementReferenceExpression
{ after(grammarAccess.getElementReferenceExpressionRule()); } 
	 EOF 
;

// Rule ElementReferenceExpression
ruleElementReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup()); }
		(rule__ElementReferenceExpression__Group__0)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveValueExpression
entryRulePrimitiveValueExpression
:
{ before(grammarAccess.getPrimitiveValueExpressionRule()); }
	 rulePrimitiveValueExpression
{ after(grammarAccess.getPrimitiveValueExpressionRule()); } 
	 EOF 
;

// Rule PrimitiveValueExpression
rulePrimitiveValueExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveValueExpressionAccess().getGroup()); }
		(rule__PrimitiveValueExpression__Group__0)
		{ after(grammarAccess.getPrimitiveValueExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIfExpression
entryRuleIfExpression
:
{ before(grammarAccess.getIfExpressionRule()); }
	 ruleIfExpression
{ after(grammarAccess.getIfExpressionRule()); } 
	 EOF 
;

// Rule IfExpression
ruleIfExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIfExpressionAccess().getGroup()); }
		(rule__IfExpression__Group__0)
		{ after(grammarAccess.getIfExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSwitchExpression
entryRuleSwitchExpression
:
{ before(grammarAccess.getSwitchExpressionRule()); }
	 ruleSwitchExpression
{ after(grammarAccess.getSwitchExpressionRule()); } 
	 EOF 
;

// Rule SwitchExpression
ruleSwitchExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSwitchExpressionAccess().getGroup()); }
		(rule__SwitchExpression__Group__0)
		{ after(grammarAccess.getSwitchExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSwitchCase
entryRuleSwitchCase
:
{ before(grammarAccess.getSwitchCaseRule()); }
	 ruleSwitchCase
{ after(grammarAccess.getSwitchCaseRule()); } 
	 EOF 
;

// Rule SwitchCase
ruleSwitchCase 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSwitchCaseAccess().getGroup()); }
		(rule__SwitchCase__Group__0)
		{ after(grammarAccess.getSwitchCaseAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnExpression
entryRuleReturnExpression
:
{ before(grammarAccess.getReturnExpressionRule()); }
	 ruleReturnExpression
{ after(grammarAccess.getReturnExpressionRule()); } 
	 EOF 
;

// Rule ReturnExpression
ruleReturnExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnExpressionAccess().getGroup()); }
		(rule__ReturnExpression__Group__0)
		{ after(grammarAccess.getReturnExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInitializationExpression
entryRuleInitializationExpression
:
{ before(grammarAccess.getInitializationExpressionRule()); }
	 ruleInitializationExpression
{ after(grammarAccess.getInitializationExpressionRule()); } 
	 EOF 
;

// Rule InitializationExpression
ruleInitializationExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInitializationExpressionAccess().getGroup()); }
		(rule__InitializationExpression__Group__0)
		{ after(grammarAccess.getInitializationExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionOrBlockExpression
entryRuleExpressionOrBlockExpression
:
{ before(grammarAccess.getExpressionOrBlockExpressionRule()); }
	 ruleExpressionOrBlockExpression
{ after(grammarAccess.getExpressionOrBlockExpressionRule()); } 
	 EOF 
;

// Rule ExpressionOrBlockExpression
ruleExpressionOrBlockExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionOrBlockExpressionAccess().getAlternatives()); }
		(rule__ExpressionOrBlockExpression__Alternatives)
		{ after(grammarAccess.getExpressionOrBlockExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBlockExpression
entryRuleBlockExpression
:
{ before(grammarAccess.getBlockExpressionRule()); }
	 ruleBlockExpression
{ after(grammarAccess.getBlockExpressionRule()); } 
	 EOF 
;

// Rule BlockExpression
ruleBlockExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockExpressionAccess().getGroup()); }
		(rule__BlockExpression__Group__0)
		{ after(grammarAccess.getBlockExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArgument
entryRuleArgument
:
{ before(grammarAccess.getArgumentRule()); }
	 ruleArgument
{ after(grammarAccess.getArgumentRule()); } 
	 EOF 
;

// Rule Argument
ruleArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentAccess().getGroup()); }
		(rule__Argument__Group__0)
		{ after(grammarAccess.getArgumentAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParenthesizedExpression
entryRuleParenthesizedExpression
:
{ before(grammarAccess.getParenthesizedExpressionRule()); }
	 ruleParenthesizedExpression
{ after(grammarAccess.getParenthesizedExpressionRule()); } 
	 EOF 
;

// Rule ParenthesizedExpression
ruleParenthesizedExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParenthesizedExpressionAccess().getGroup()); }
		(rule__ParenthesizedExpression__Group__0)
		{ after(grammarAccess.getParenthesizedExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeSpecifier
entryRuleTypeSpecifier
:
{ before(grammarAccess.getTypeSpecifierRule()); }
	 ruleTypeSpecifier
{ after(grammarAccess.getTypeSpecifierRule()); } 
	 EOF 
;

// Rule TypeSpecifier
ruleTypeSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getGroup()); }
		(rule__TypeSpecifier__Group__0)
		{ after(grammarAccess.getTypeSpecifierAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleQID
entryRuleQID
:
{ before(grammarAccess.getQIDRule()); }
	 ruleQID
{ after(grammarAccess.getQIDRule()); } 
	 EOF 
;

// Rule QID
ruleQID 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getQIDAccess().getGroup()); }
		(rule__QID__Group__0)
		{ after(grammarAccess.getQIDAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReferenceKeywords
entryRuleReferenceKeywords
:
{ before(grammarAccess.getReferenceKeywordsRule()); }
	 ruleReferenceKeywords
{ after(grammarAccess.getReferenceKeywordsRule()); } 
	 EOF 
;

// Rule ReferenceKeywords
ruleReferenceKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getAlternatives()); }
		(rule__ReferenceKeywords__Alternatives)
		{ after(grammarAccess.getReferenceKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOtherKeywords
entryRuleOtherKeywords
:
{ before(grammarAccess.getOtherKeywordsRule()); }
	 ruleOtherKeywords
{ after(grammarAccess.getOtherKeywordsRule()); } 
	 EOF 
;

// Rule OtherKeywords
ruleOtherKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getAlternatives()); }
		(rule__OtherKeywords__Alternatives)
		{ after(grammarAccess.getOtherKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRefIDWithKeywords
entryRuleRefIDWithKeywords
:
{ before(grammarAccess.getRefIDWithKeywordsRule()); }
	 ruleRefIDWithKeywords
{ after(grammarAccess.getRefIDWithKeywordsRule()); } 
	 EOF 
;

// Rule RefIDWithKeywords
ruleRefIDWithKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRefIDWithKeywordsAccess().getAlternatives()); }
		(rule__RefIDWithKeywords__Alternatives)
		{ after(grammarAccess.getRefIDWithKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteral
entryRuleLiteral
:
{ before(grammarAccess.getLiteralRule()); }
	 ruleLiteral
{ after(grammarAccess.getLiteralRule()); } 
	 EOF 
;

// Rule Literal
ruleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralAccess().getAlternatives()); }
		(rule__Literal__Alternatives)
		{ after(grammarAccess.getLiteralAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBoolLiteral
entryRuleBoolLiteral
:
{ before(grammarAccess.getBoolLiteralRule()); }
	 ruleBoolLiteral
{ after(grammarAccess.getBoolLiteralRule()); } 
	 EOF 
;

// Rule BoolLiteral
ruleBoolLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBoolLiteralAccess().getGroup()); }
		(rule__BoolLiteral__Group__0)
		{ after(grammarAccess.getBoolLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntLiteral
entryRuleIntLiteral
:
{ before(grammarAccess.getIntLiteralRule()); }
	 ruleIntLiteral
{ after(grammarAccess.getIntLiteralRule()); } 
	 EOF 
;

// Rule IntLiteral
ruleIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntLiteralAccess().getGroup()); }
		(rule__IntLiteral__Group__0)
		{ after(grammarAccess.getIntLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral
:
{ before(grammarAccess.getDoubleLiteralRule()); }
	 ruleDoubleLiteral
{ after(grammarAccess.getDoubleLiteralRule()); } 
	 EOF 
;

// Rule DoubleLiteral
ruleDoubleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDoubleLiteralAccess().getGroup()); }
		(rule__DoubleLiteral__Group__0)
		{ after(grammarAccess.getDoubleLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFloatLiteral
entryRuleFloatLiteral
:
{ before(grammarAccess.getFloatLiteralRule()); }
	 ruleFloatLiteral
{ after(grammarAccess.getFloatLiteralRule()); } 
	 EOF 
;

// Rule FloatLiteral
ruleFloatLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFloatLiteralAccess().getGroup()); }
		(rule__FloatLiteral__Group__0)
		{ after(grammarAccess.getFloatLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleHexLiteral
entryRuleHexLiteral
:
{ before(grammarAccess.getHexLiteralRule()); }
	 ruleHexLiteral
{ after(grammarAccess.getHexLiteralRule()); } 
	 EOF 
;

// Rule HexLiteral
ruleHexLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getHexLiteralAccess().getGroup()); }
		(rule__HexLiteral__Group__0)
		{ after(grammarAccess.getHexLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBinaryLiteral
entryRuleBinaryLiteral
:
{ before(grammarAccess.getBinaryLiteralRule()); }
	 ruleBinaryLiteral
{ after(grammarAccess.getBinaryLiteralRule()); } 
	 EOF 
;

// Rule BinaryLiteral
ruleBinaryLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBinaryLiteralAccess().getGroup()); }
		(rule__BinaryLiteral__Group__0)
		{ after(grammarAccess.getBinaryLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStringLiteral
entryRuleStringLiteral
:
{ before(grammarAccess.getStringLiteralRule()); }
	 ruleStringLiteral
{ after(grammarAccess.getStringLiteralRule()); } 
	 EOF 
;

// Rule StringLiteral
ruleStringLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStringLiteralAccess().getGroup()); }
		(rule__StringLiteral__Group__0)
		{ after(grammarAccess.getStringLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNullLiteral
entryRuleNullLiteral
:
{ before(grammarAccess.getNullLiteralRule()); }
	 ruleNullLiteral
{ after(grammarAccess.getNullLiteralRule()); } 
	 EOF 
;

// Rule NullLiteral
ruleNullLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNullLiteralAccess().getGroup()); }
		(rule__NullLiteral__Group__0)
		{ after(grammarAccess.getNullLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalAndOperator
entryRuleLogicalAndOperator
:
{ before(grammarAccess.getLogicalAndOperatorRule()); }
	 ruleLogicalAndOperator
{ after(grammarAccess.getLogicalAndOperatorRule()); } 
	 EOF 
;

// Rule LogicalAndOperator
ruleLogicalAndOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword()); }
		'&&'
		{ after(grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalOrOperator
entryRuleLogicalOrOperator
:
{ before(grammarAccess.getLogicalOrOperatorRule()); }
	 ruleLogicalOrOperator
{ after(grammarAccess.getLogicalOrOperatorRule()); } 
	 EOF 
;

// Rule LogicalOrOperator
ruleLogicalOrOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword()); }
		'||'
		{ after(grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalNotOperator
entryRuleLogicalNotOperator
:
{ before(grammarAccess.getLogicalNotOperatorRule()); }
	 ruleLogicalNotOperator
{ after(grammarAccess.getLogicalNotOperatorRule()); } 
	 EOF 
;

// Rule LogicalNotOperator
ruleLogicalNotOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword()); }
		'!'
		{ after(grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXOrOperator
entryRuleBitwiseXOrOperator
:
{ before(grammarAccess.getBitwiseXOrOperatorRule()); }
	 ruleBitwiseXOrOperator
{ after(grammarAccess.getBitwiseXOrOperatorRule()); } 
	 EOF 
;

// Rule BitwiseXOrOperator
ruleBitwiseXOrOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword()); }
		'^'
		{ after(grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseOrOperator
entryRuleBitwiseOrOperator
:
{ before(grammarAccess.getBitwiseOrOperatorRule()); }
	 ruleBitwiseOrOperator
{ after(grammarAccess.getBitwiseOrOperatorRule()); } 
	 EOF 
;

// Rule BitwiseOrOperator
ruleBitwiseOrOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword()); }
		'|'
		{ after(grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseAndOperator
entryRuleBitwiseAndOperator
:
{ before(grammarAccess.getBitwiseAndOperatorRule()); }
	 ruleBitwiseAndOperator
{ after(grammarAccess.getBitwiseAndOperatorRule()); } 
	 EOF 
;

// Rule BitwiseAndOperator
ruleBitwiseAndOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword()); }
		'&'
		{ after(grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PostFixOperator
rulePostFixOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostFixOperatorAccess().getAlternatives()); }
		(rule__PostFixOperator__Alternatives)
		{ after(grammarAccess.getPostFixOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AssignmentOperator
ruleAssignmentOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
		(rule__AssignmentOperator__Alternatives)
		{ after(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ShiftOperator
ruleShiftOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftOperatorAccess().getAlternatives()); }
		(rule__ShiftOperator__Alternatives)
		{ after(grammarAccess.getShiftOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AdditiveOperator
ruleAdditiveOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); }
		(rule__AdditiveOperator__Alternatives)
		{ after(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule MultiplicativeOperator
ruleMultiplicativeOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); }
		(rule__MultiplicativeOperator__Alternatives)
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule UnaryOperator
ruleUnaryOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getAlternatives()); }
		(rule__UnaryOperator__Alternatives)
		{ after(grammarAccess.getUnaryOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule RelationalOperator
ruleRelationalOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getAlternatives()); }
		(rule__RelationalOperator__Alternatives)
		{ after(grammarAccess.getRelationalOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getConstAssignment_0_0()); }
		(rule__PropertyDefinition__ConstAssignment_0_0)
		{ after(grammarAccess.getPropertyDefinitionAccess().getConstAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getVarKeyword_0_1()); }
		'var'
		{ after(grammarAccess.getPropertyDefinitionAccess().getVarKeyword_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Alternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGENERATOR_IDAccess().getColonColonKeyword_1_0_0()); }
		'::'
		{ after(grammarAccess.getGENERATOR_IDAccess().getColonColonKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getGENERATOR_IDAccess().getFullStopKeyword_1_0_1()); }
		'.'
		{ after(grammarAccess.getGENERATOR_IDAccess().getFullStopKeyword_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0()); }
		ruleBitwiseOrExpression
		{ after(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getGroup_1()); }
		(rule__LogicalNotExpression__Group_1__0)
		{ after(grammarAccess.getLogicalNotExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0()); }
		rulePostFixUnaryExpression
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1()); }
		(rule__NumericalUnaryExpression__Group_1__0)
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Alternatives_1_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_0()); }
		(rule__FeatureCall__Group_1_0_0_0__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_1()); }
		(rule__FeatureCall__Group_1_0_0_1__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Alternatives_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0()); }
		(rule__FeatureCall__Group_1_0_2_0__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1()); }
		(rule__FeatureCall__Group_1_0_2_1__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_0()); }
		ruleElementReferenceExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_1()); }
		rulePrimitiveValueExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_2()); }
		ruleParenthesizedExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getIfExpressionParserRuleCall_3()); }
		ruleIfExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getIfExpressionParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getReturnExpressionParserRuleCall_4()); }
		ruleReturnExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getReturnExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getSwitchExpressionParserRuleCall_5()); }
		ruleSwitchExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getSwitchExpressionParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_6()); }
		ruleInitializationExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0()); }
		(rule__ElementReferenceExpression__Group_2_0__0)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1()); }
		(rule__ElementReferenceExpression__Group_2_1__0)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionOrBlockExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExpressionOrBlockExpressionAccess().getExpressionParserRuleCall_0()); }
		ruleExpression
		{ after(grammarAccess.getExpressionOrBlockExpressionAccess().getExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getExpressionOrBlockExpressionAccess().getBlockExpressionParserRuleCall_1()); }
		(ruleBlockExpression)
		{ after(grammarAccess.getExpressionOrBlockExpressionAccess().getBlockExpressionParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReferenceKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getAsKeyword_0()); }
		'as'
		{ after(grammarAccess.getReferenceKeywordsAccess().getAsKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getDefaultKeyword_1()); }
		'default'
		{ after(grammarAccess.getReferenceKeywordsAccess().getDefaultKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getCaseKeyword_2()); }
		'case'
		{ after(grammarAccess.getReferenceKeywordsAccess().getCaseKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getElseKeyword_3()); }
		'else'
		{ after(grammarAccess.getReferenceKeywordsAccess().getElseKeyword_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getIfKeyword_0()); }
		'if'
		{ after(grammarAccess.getOtherKeywordsAccess().getIfKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getSwitchKeyword_1()); }
		'switch'
		{ after(grammarAccess.getOtherKeywordsAccess().getSwitchKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getReturnKeyword_2()); }
		'return'
		{ after(grammarAccess.getOtherKeywordsAccess().getReturnKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getRaiseKeyword_3()); }
		'raise'
		{ after(grammarAccess.getOtherKeywordsAccess().getRaiseKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getValueofKeyword_4()); }
		'valueof'
		{ after(grammarAccess.getOtherKeywordsAccess().getValueofKeyword_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefIDWithKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0()); }
		RULE_ID
		{ after(grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1()); }
		ruleReferenceKeywords
		{ after(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Literal__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0()); }
		ruleBoolLiteral
		{ after(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1()); }
		ruleIntLiteral
		{ after(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2()); }
		ruleHexLiteral
		{ after(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3()); }
		ruleBinaryLiteral
		{ after(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4()); }
		ruleDoubleLiteral
		{ after(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5()); }
		ruleFloatLiteral
		{ after(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6()); }
		ruleStringLiteral
		{ after(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7()); }
		ruleNullLiteral
		{ after(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0()); }
		('++')
		{ after(grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1()); }
		('--')
		{ after(grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0()); }
		('=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1()); }
		('*=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2()); }
		('/=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3()); }
		('%=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4()); }
		('+=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5()); }
		('-=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6()); }
		('<<=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7()); }
		('>>=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8()); }
		('&=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9()); }
		('^=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10()); }
		('|=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0()); }
		('<<')
		{ after(grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1()); }
		('>>')
		{ after(grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0()); }
		('+')
		{ after(grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1()); }
		('-')
		{ after(grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0()); }
		('*')
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1()); }
		('/')
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2()); }
		('%')
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0()); }
		('+')
		{ after(grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1()); }
		('-')
		{ after(grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2()); }
		('~')
		{ after(grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RelationalOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0()); }
		('<')
		{ after(grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1()); }
		('<=')
		{ after(grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2()); }
		('>')
		{ after(grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3()); }
		('>=')
		{ after(grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4()); }
		('==')
		{ after(grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5()); }
		('!=')
		{ after(grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__0__Impl
	rule__GeneratorModel__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getGeneratorModelKeyword_0()); }
	'GeneratorModel'
	{ after(grammarAccess.getGeneratorModelAccess().getGeneratorModelKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__1__Impl
	rule__GeneratorModel__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getForKeyword_1()); }
	'for'
	{ after(grammarAccess.getGeneratorModelAccess().getForKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__2__Impl
	rule__GeneratorModel__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getGeneratorIdAssignment_2()); }
	(rule__GeneratorModel__GeneratorIdAssignment_2)
	{ after(grammarAccess.getGeneratorModelAccess().getGeneratorIdAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__3__Impl
	rule__GeneratorModel__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getGeneratorModelAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__4__Impl
	rule__GeneratorModel__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getPropertiesAssignment_4()); }
	(rule__GeneratorModel__PropertiesAssignment_4)*
	{ after(grammarAccess.getGeneratorModelAccess().getPropertiesAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__5__Impl
	rule__GeneratorModel__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getEntriesAssignment_5()); }
	(rule__GeneratorModel__EntriesAssignment_5)*
	{ after(grammarAccess.getGeneratorModelAccess().getEntriesAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorModel__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorModelAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getGeneratorModelAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyDefinition__Group__0__Impl
	rule__PropertyDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyDefinitionAccess().getAlternatives_0()); }
	(rule__PropertyDefinition__Alternatives_0)
	{ after(grammarAccess.getPropertyDefinitionAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyDefinition__Group__1__Impl
	rule__PropertyDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyDefinitionAccess().getNameAssignment_1()); }
	(rule__PropertyDefinition__NameAssignment_1)
	{ after(grammarAccess.getPropertyDefinitionAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyDefinition__Group__2__Impl
	rule__PropertyDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyDefinitionAccess().getColonKeyword_2()); }
	':'
	{ after(grammarAccess.getPropertyDefinitionAccess().getColonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyDefinition__Group__3__Impl
	rule__PropertyDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyDefinitionAccess().getTypeSpecifierAssignment_3()); }
	(rule__PropertyDefinition__TypeSpecifierAssignment_3)
	{ after(grammarAccess.getPropertyDefinitionAccess().getTypeSpecifierAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyDefinition__Group__4__Impl
	rule__PropertyDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyDefinitionAccess().getEqualsSignKeyword_4()); }
	'='
	{ after(grammarAccess.getPropertyDefinitionAccess().getEqualsSignKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyDefinition__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyDefinitionAccess().getInitialValueAssignment_5()); }
	(rule__PropertyDefinition__InitialValueAssignment_5)
	{ after(grammarAccess.getPropertyDefinitionAccess().getInitialValueAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GeneratorEntry__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorEntry__Group__0__Impl
	rule__GeneratorEntry__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorEntryAccess().getKeywordAssignment_0()); }
	(rule__GeneratorEntry__KeywordAssignment_0)
	{ after(grammarAccess.getGeneratorEntryAccess().getKeywordAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorEntry__Group__1__Impl
	rule__GeneratorEntry__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorEntryAccess().getElementRefAssignment_1()); }
	(rule__GeneratorEntry__ElementRefAssignment_1)
	{ after(grammarAccess.getGeneratorEntryAccess().getElementRefAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorEntry__Group__2__Impl
	rule__GeneratorEntry__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorEntryAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getGeneratorEntryAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorEntry__Group__3__Impl
	rule__GeneratorEntry__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorEntryAccess().getFeaturesAssignment_3()); }
	(rule__GeneratorEntry__FeaturesAssignment_3)*
	{ after(grammarAccess.getGeneratorEntryAccess().getFeaturesAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratorEntry__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratorEntryAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getGeneratorEntryAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureConfiguration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureConfiguration__Group__0__Impl
	rule__FeatureConfiguration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureConfigurationAccess().getFeatureConfigurationAction_0()); }
	()
	{ after(grammarAccess.getFeatureConfigurationAccess().getFeatureConfigurationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureConfiguration__Group__1__Impl
	rule__FeatureConfiguration__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureConfigurationAccess().getFeatureKeyword_1()); }
	'feature'
	{ after(grammarAccess.getFeatureConfigurationAccess().getFeatureKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureConfiguration__Group__2__Impl
	rule__FeatureConfiguration__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureConfigurationAccess().getTypeAssignment_2()); }
	(rule__FeatureConfiguration__TypeAssignment_2)
	{ after(grammarAccess.getFeatureConfigurationAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureConfiguration__Group__3__Impl
	rule__FeatureConfiguration__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureConfigurationAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getFeatureConfigurationAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureConfiguration__Group__4__Impl
	rule__FeatureConfiguration__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureConfigurationAccess().getParameterValuesAssignment_4()); }
	(rule__FeatureConfiguration__ParameterValuesAssignment_4)*
	{ after(grammarAccess.getFeatureConfigurationAccess().getParameterValuesAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureConfiguration__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureConfigurationAccess().getRightCurlyBracketKeyword_5()); }
	'}'
	{ after(grammarAccess.getFeatureConfigurationAccess().getRightCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureParameterValue__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureParameterValue__Group__0__Impl
	rule__FeatureParameterValue__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureParameterValueAccess().getFeatureParameterValueAction_0()); }
	()
	{ after(grammarAccess.getFeatureParameterValueAccess().getFeatureParameterValueAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureParameterValue__Group__1__Impl
	rule__FeatureParameterValue__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureParameterValueAccess().getParameterAssignment_1()); }
	(rule__FeatureParameterValue__ParameterAssignment_1)
	{ after(grammarAccess.getFeatureParameterValueAccess().getParameterAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureParameterValue__Group__2__Impl
	rule__FeatureParameterValue__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureParameterValueAccess().getEqualsSignKeyword_2()); }
	'='
	{ after(grammarAccess.getFeatureParameterValueAccess().getEqualsSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureParameterValue__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureParameterValueAccess().getExpressionAssignment_3()); }
	(rule__FeatureParameterValue__ExpressionAssignment_3)
	{ after(grammarAccess.getFeatureParameterValueAccess().getExpressionAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GENERATOR_ID__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GENERATOR_ID__Group__0__Impl
	rule__GENERATOR_ID__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGENERATOR_IDAccess().getIDTerminalRuleCall_0()); }
	RULE_ID
	{ after(grammarAccess.getGENERATOR_IDAccess().getIDTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GENERATOR_ID__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGENERATOR_IDAccess().getGroup_1()); }
	(rule__GENERATOR_ID__Group_1__0)*
	{ after(grammarAccess.getGENERATOR_IDAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GENERATOR_ID__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GENERATOR_ID__Group_1__0__Impl
	rule__GENERATOR_ID__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGENERATOR_IDAccess().getAlternatives_1_0()); }
	(rule__GENERATOR_ID__Alternatives_1_0)
	{ after(grammarAccess.getGENERATOR_IDAccess().getAlternatives_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GENERATOR_ID__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GENERATOR_ID__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGENERATOR_IDAccess().getIDTerminalRuleCall_1_1()); }
	RULE_ID
	{ after(grammarAccess.getGENERATOR_IDAccess().getIDTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssignmentExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group__0__Impl
	rule__AssignmentExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0()); }
	ruleConditionalExpression
	{ after(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_1()); }
	(rule__AssignmentExpression__Group_1__0)*
	{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssignmentExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_1_0()); }
	(rule__AssignmentExpression__Group_1_0__0)
	{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssignmentExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1_0__0__Impl
	rule__AssignmentExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0()); }
	()
	{ after(grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1_0__1__Impl
	rule__AssignmentExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__AssignmentExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getExpressionAssignment_1_0_2()); }
	(rule__AssignmentExpression__ExpressionAssignment_1_0_2)
	{ after(grammarAccess.getAssignmentExpressionAccess().getExpressionAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConditionalExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group__0__Impl
	rule__ConditionalExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0()); }
	ruleLogicalOrExpression
	{ after(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getGroup_1()); }
	(rule__ConditionalExpression__Group_1__0)?
	{ after(grammarAccess.getConditionalExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConditionalExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getGroup_1_0()); }
	(rule__ConditionalExpression__Group_1_0__0)
	{ after(grammarAccess.getConditionalExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConditionalExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__0__Impl
	rule__ConditionalExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0()); }
	()
	{ after(grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__1__Impl
	rule__ConditionalExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1()); }
	'?'
	{ after(grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__2__Impl
	rule__ConditionalExpression__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getTrueCaseAssignment_1_0_2()); }
	(rule__ConditionalExpression__TrueCaseAssignment_1_0_2)
	{ after(grammarAccess.getConditionalExpressionAccess().getTrueCaseAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__3__Impl
	rule__ConditionalExpression__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3()); }
	':'
	{ after(grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getFalseCaseAssignment_1_0_4()); }
	(rule__ConditionalExpression__FalseCaseAssignment_1_0_4)
	{ after(grammarAccess.getConditionalExpressionAccess().getFalseCaseAssignment_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalOrExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group__0__Impl
	rule__LogicalOrExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0()); }
	ruleLogicalAndExpression
	{ after(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup_1()); }
	(rule__LogicalOrExpression__Group_1__0)*
	{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalOrExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup_1_0()); }
	(rule__LogicalOrExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalOrExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1_0__0__Impl
	rule__LogicalOrExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1_0__1__Impl
	rule__LogicalOrExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1()); }
	ruleLogicalOrOperator
	{ after(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__LogicalOrExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalAndExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group__0__Impl
	rule__LogicalAndExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0()); }
	ruleLogicalNotExpression
	{ after(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup_1()); }
	(rule__LogicalAndExpression__Group_1__0)*
	{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalAndExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup_1_0()); }
	(rule__LogicalAndExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalAndExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1_0__0__Impl
	rule__LogicalAndExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1_0__1__Impl
	rule__LogicalAndExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1()); }
	ruleLogicalAndOperator
	{ after(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__LogicalAndExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalNotExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getGroup_1_0()); }
	(rule__LogicalNotExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalNotExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalNotExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1_0__0__Impl
	rule__LogicalNotExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1_0__1__Impl
	rule__LogicalNotExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1()); }
	ruleLogicalNotOperator
	{ after(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getOperandAssignment_1_0_2()); }
	(rule__LogicalNotExpression__OperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalNotExpressionAccess().getOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseOrExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group__0__Impl
	rule__BitwiseOrExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0()); }
	ruleBitwiseXorExpression
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1()); }
	(rule__BitwiseOrExpression__Group_1__0)*
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseOrExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1_0()); }
	(rule__BitwiseOrExpression__Group_1_0__0)
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseOrExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1_0__0__Impl
	rule__BitwiseOrExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1_0__1__Impl
	rule__BitwiseOrExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1()); }
	ruleBitwiseOrOperator
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__BitwiseOrExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseXorExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group__0__Impl
	rule__BitwiseXorExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0()); }
	ruleBitwiseAndExpression
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1()); }
	(rule__BitwiseXorExpression__Group_1__0)*
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseXorExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1_0()); }
	(rule__BitwiseXorExpression__Group_1_0__0)
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseXorExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1_0__0__Impl
	rule__BitwiseXorExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1_0__1__Impl
	rule__BitwiseXorExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1()); }
	ruleBitwiseXOrOperator
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__BitwiseXorExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseAndExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group__0__Impl
	rule__BitwiseAndExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0()); }
	ruleLogicalRelationExpression
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1()); }
	(rule__BitwiseAndExpression__Group_1__0)*
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseAndExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1_0()); }
	(rule__BitwiseAndExpression__Group_1_0__0)
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseAndExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1_0__0__Impl
	rule__BitwiseAndExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1_0__1__Impl
	rule__BitwiseAndExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1()); }
	ruleBitwiseAndOperator
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__BitwiseAndExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalRelationExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group__0__Impl
	rule__LogicalRelationExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0()); }
	ruleShiftExpression
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1()); }
	(rule__LogicalRelationExpression__Group_1__0)*
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalRelationExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1_0()); }
	(rule__LogicalRelationExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalRelationExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1_0__0__Impl
	rule__LogicalRelationExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1_0__1__Impl
	rule__LogicalRelationExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__LogicalRelationExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__LogicalRelationExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ShiftExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group__0__Impl
	rule__ShiftExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0()); }
	ruleNumericalAddSubtractExpression
	{ after(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getGroup_1()); }
	(rule__ShiftExpression__Group_1__0)*
	{ after(grammarAccess.getShiftExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ShiftExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getGroup_1_0()); }
	(rule__ShiftExpression__Group_1_0__0)
	{ after(grammarAccess.getShiftExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ShiftExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1_0__0__Impl
	rule__ShiftExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1_0__1__Impl
	rule__ShiftExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__ShiftExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getShiftExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__ShiftExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getShiftExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalAddSubtractExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group__0__Impl
	rule__NumericalAddSubtractExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0()); }
	ruleNumericalMultiplyDivideExpression
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1()); }
	(rule__NumericalAddSubtractExpression__Group_1__0)*
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalAddSubtractExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1_0()); }
	(rule__NumericalAddSubtractExpression__Group_1_0__0)
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalAddSubtractExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1_0__0__Impl
	rule__NumericalAddSubtractExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1_0__1__Impl
	rule__NumericalAddSubtractExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__NumericalAddSubtractExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__NumericalAddSubtractExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalMultiplyDivideExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group__0__Impl
	rule__NumericalMultiplyDivideExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0()); }
	ruleNumericalUnaryExpression
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1()); }
	(rule__NumericalMultiplyDivideExpression__Group_1__0)*
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalMultiplyDivideExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1_0()); }
	(rule__NumericalMultiplyDivideExpression__Group_1_0__0)
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalMultiplyDivideExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1_0__0__Impl
	rule__NumericalMultiplyDivideExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1_0__1__Impl
	rule__NumericalMultiplyDivideExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__NumericalMultiplyDivideExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__NumericalMultiplyDivideExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalUnaryExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1_0()); }
	(rule__NumericalUnaryExpression__Group_1_0__0)
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalUnaryExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1_0__0__Impl
	rule__NumericalUnaryExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0()); }
	()
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1_0__1__Impl
	rule__NumericalUnaryExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__NumericalUnaryExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperandAssignment_1_0_2()); }
	(rule__NumericalUnaryExpression__OperandAssignment_1_0_2)
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostFixUnaryExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group__0__Impl
	rule__PostFixUnaryExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0()); }
	ruleTypeCastExpression
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1()); }
	(rule__PostFixUnaryExpression__Group_1__0)*
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostFixUnaryExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1_0()); }
	(rule__PostFixUnaryExpression__Group_1_0__0)
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostFixUnaryExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group_1_0__0__Impl
	rule__PostFixUnaryExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__PostFixUnaryExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group__0__Impl
	rule__TypeCastExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0()); }
	ruleFeatureCall
	{ after(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getGroup_1()); }
	(rule__TypeCastExpression__Group_1__0)*
	{ after(grammarAccess.getTypeCastExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0()); }
	(rule__TypeCastExpression__Group_1_0__0)
	{ after(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0__0__Impl
	rule__TypeCastExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0_0()); }
	(rule__TypeCastExpression__Group_1_0_0__0)
	{ after(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierAssignment_1_0_1()); }
	(rule__TypeCastExpression__TypeSpecifierAssignment_1_0_1)
	{ after(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0_0__0__Impl
	rule__TypeCastExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1()); }
	'as'
	{ after(grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group__0__Impl
	rule__FeatureCall__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0()); }
	rulePrimaryExpression
	{ after(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1()); }
	(rule__FeatureCall__Group_1__0)*
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0()); }
	(rule__FeatureCall__Group_1_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0__0__Impl
	rule__FeatureCall__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_0()); }
	(rule__FeatureCall__Alternatives_1_0_0)
	{ after(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0__1__Impl
	rule__FeatureCall__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFeatureAssignment_1_0_1()); }
	(rule__FeatureCall__FeatureAssignment_1_0_1)
	{ after(grammarAccess.getFeatureCallAccess().getFeatureAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_2()); }
	(rule__FeatureCall__Alternatives_1_0_2)?
	{ after(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_0__0__Impl
	rule__FeatureCall__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0()); }
	()
	{ after(grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1()); }
	('.')
	{ after(grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_1__0__Impl
	rule__FeatureCall__Group_1_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0()); }
	()
	{ after(grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1()); }
	'.@'
	{ after(grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0__0__Impl
	rule__FeatureCall__Group_1_0_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getOperationCallAssignment_1_0_2_0_0()); }
	(rule__FeatureCall__OperationCallAssignment_1_0_2_0_0)
	{ after(grammarAccess.getFeatureCallAccess().getOperationCallAssignment_1_0_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0__1__Impl
	rule__FeatureCall__Group_1_0_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1()); }
	(rule__FeatureCall__Group_1_0_2_0_1__0)?
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2()); }
	')'
	{ after(grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1__0__Impl
	rule__FeatureCall__Group_1_0_2_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_0()); }
	(rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_0)
	{ after(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1_1()); }
	(rule__FeatureCall__Group_1_0_2_0_1_1__0)*
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1_1__0__Impl
	rule__FeatureCall__Group_1_0_2_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0()); }
	','
	{ after(grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_1_1()); }
	(rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_1_1)
	{ after(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1__0__Impl
	rule__FeatureCall__Group_1_0_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0()); }
	(rule__FeatureCall__Group_1_0_2_1_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1()); }
	(rule__FeatureCall__Group_1_0_2_1_1__0)*
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0_0()); }
	(rule__FeatureCall__Group_1_0_2_1_0_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0_0__0__Impl
	rule__FeatureCall__Group_1_0_2_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArrayAccessAssignment_1_0_2_1_0_0_0()); }
	(rule__FeatureCall__ArrayAccessAssignment_1_0_2_1_0_0_0)
	{ after(grammarAccess.getFeatureCallAccess().getArrayAccessAssignment_1_0_2_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0_0__1__Impl
	rule__FeatureCall__Group_1_0_2_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_0_0_1()); }
	(rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_0_0_1)
	{ after(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2()); }
	']'
	{ after(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1_0()); }
	(rule__FeatureCall__Group_1_0_2_1_1_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1_0__0__Impl
	rule__FeatureCall__Group_1_0_2_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0()); }
	'['
	{ after(grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1_0__1__Impl
	rule__FeatureCall__Group_1_0_2_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_1_0_1()); }
	(rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_1_0_1)
	{ after(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2()); }
	']'
	{ after(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group__0__Impl
	rule__ElementReferenceExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0()); }
	()
	{ after(grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group__1__Impl
	rule__ElementReferenceExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getReferenceAssignment_1()); }
	(rule__ElementReferenceExpression__ReferenceAssignment_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getReferenceAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getAlternatives_2()); }
	(rule__ElementReferenceExpression__Alternatives_2)?
	{ after(grammarAccess.getElementReferenceExpressionAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0__0__Impl
	rule__ElementReferenceExpression__Group_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getOperationCallAssignment_2_0_0()); }
	(rule__ElementReferenceExpression__OperationCallAssignment_2_0_0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getOperationCallAssignment_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0__1__Impl
	rule__ElementReferenceExpression__Group_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1()); }
	(rule__ElementReferenceExpression__Group_2_0_1__0)?
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2()); }
	')'
	{ after(grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1__0__Impl
	rule__ElementReferenceExpression__Group_2_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_0()); }
	(rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1_1()); }
	(rule__ElementReferenceExpression__Group_2_0_1_1__0)*
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1_1__0__Impl
	rule__ElementReferenceExpression__Group_2_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0()); }
	','
	{ after(grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_1_1()); }
	(rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_1_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1__0__Impl
	rule__ElementReferenceExpression__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0()); }
	(rule__ElementReferenceExpression__Group_2_1_0__0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1()); }
	(rule__ElementReferenceExpression__Group_2_1_1__0)*
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0_0()); }
	(rule__ElementReferenceExpression__Group_2_1_0_0__0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0_0__0__Impl
	rule__ElementReferenceExpression__Group_2_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessAssignment_2_1_0_0_0()); }
	(rule__ElementReferenceExpression__ArrayAccessAssignment_2_1_0_0_0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessAssignment_2_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0_0__1__Impl
	rule__ElementReferenceExpression__Group_2_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_0_0_1()); }
	(rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_0_0_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2()); }
	']'
	{ after(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1_0()); }
	(rule__ElementReferenceExpression__Group_2_1_1_0__0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1_0__0__Impl
	rule__ElementReferenceExpression__Group_2_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0()); }
	'['
	{ after(grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1_0__1__Impl
	rule__ElementReferenceExpression__Group_2_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_1_0_1()); }
	(rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_1_0_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2()); }
	']'
	{ after(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveValueExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveValueExpression__Group__0__Impl
	rule__PrimitiveValueExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveValueExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveValueExpressionAccess().getValueAssignment_1()); }
	(rule__PrimitiveValueExpression__ValueAssignment_1)
	{ after(grammarAccess.getPrimitiveValueExpressionAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IfExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__0__Impl
	rule__IfExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getIfExpressionAction_0()); }
	()
	{ after(grammarAccess.getIfExpressionAccess().getIfExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__1__Impl
	rule__IfExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getIfKeyword_1()); }
	'if'
	{ after(grammarAccess.getIfExpressionAccess().getIfKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__2__Impl
	rule__IfExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getLeftParenthesisKeyword_2()); }
	'('
	{ after(grammarAccess.getIfExpressionAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__3__Impl
	rule__IfExpression__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getConditionAssignment_3()); }
	(rule__IfExpression__ConditionAssignment_3)
	{ after(grammarAccess.getIfExpressionAccess().getConditionAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__4__Impl
	rule__IfExpression__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getIfExpressionAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__5__Impl
	rule__IfExpression__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getThenAssignment_5()); }
	(rule__IfExpression__ThenAssignment_5)
	{ after(grammarAccess.getIfExpressionAccess().getThenAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getGroup_6()); }
	(rule__IfExpression__Group_6__0)?
	{ after(grammarAccess.getIfExpressionAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IfExpression__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group_6__0__Impl
	rule__IfExpression__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getElseKeyword_6_0()); }
	('else')
	{ after(grammarAccess.getIfExpressionAccess().getElseKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfExpression__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfExpressionAccess().getElseAssignment_6_1()); }
	(rule__IfExpression__ElseAssignment_6_1)
	{ after(grammarAccess.getIfExpressionAccess().getElseAssignment_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SwitchExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__0__Impl
	rule__SwitchExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getSwitchExpressionAction_0()); }
	()
	{ after(grammarAccess.getSwitchExpressionAccess().getSwitchExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__1__Impl
	rule__SwitchExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getSwitchKeyword_1()); }
	'switch'
	{ after(grammarAccess.getSwitchExpressionAccess().getSwitchKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__2__Impl
	rule__SwitchExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getLeftParenthesisKeyword_2()); }
	'('
	{ after(grammarAccess.getSwitchExpressionAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__3__Impl
	rule__SwitchExpression__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getSwitchAssignment_3()); }
	(rule__SwitchExpression__SwitchAssignment_3)
	{ after(grammarAccess.getSwitchExpressionAccess().getSwitchAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__4__Impl
	rule__SwitchExpression__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getSwitchExpressionAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__5__Impl
	rule__SwitchExpression__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getLeftCurlyBracketKeyword_5()); }
	'{'
	{ after(grammarAccess.getSwitchExpressionAccess().getLeftCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__6__Impl
	rule__SwitchExpression__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getCasesAssignment_6()); }
	(rule__SwitchExpression__CasesAssignment_6)*
	{ after(grammarAccess.getSwitchExpressionAccess().getCasesAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__7__Impl
	rule__SwitchExpression__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getGroup_7()); }
	(rule__SwitchExpression__Group_7__0)?
	{ after(grammarAccess.getSwitchExpressionAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getRightCurlyBracketKeyword_8()); }
	'}'
	{ after(grammarAccess.getSwitchExpressionAccess().getRightCurlyBracketKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SwitchExpression__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group_7__0__Impl
	rule__SwitchExpression__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getDefaultKeyword_7_0()); }
	'default'
	{ after(grammarAccess.getSwitchExpressionAccess().getDefaultKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group_7__1__Impl
	rule__SwitchExpression__Group_7__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getColonKeyword_7_1()); }
	':'
	{ after(grammarAccess.getSwitchExpressionAccess().getColonKeyword_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group_7__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchExpression__Group_7__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__Group_7__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchExpressionAccess().getDefaultAssignment_7_2()); }
	(rule__SwitchExpression__DefaultAssignment_7_2)
	{ after(grammarAccess.getSwitchExpressionAccess().getDefaultAssignment_7_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SwitchCase__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchCase__Group__0__Impl
	rule__SwitchCase__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchCaseAccess().getSwitchCaseAction_0()); }
	()
	{ after(grammarAccess.getSwitchCaseAccess().getSwitchCaseAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchCase__Group__1__Impl
	rule__SwitchCase__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchCaseAccess().getCaseKeyword_1()); }
	'case'
	{ after(grammarAccess.getSwitchCaseAccess().getCaseKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchCase__Group__2__Impl
	rule__SwitchCase__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchCaseAccess().getCaseAssignment_2()); }
	(rule__SwitchCase__CaseAssignment_2)
	{ after(grammarAccess.getSwitchCaseAccess().getCaseAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchCase__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchCaseAccess().getGroup_3()); }
	(rule__SwitchCase__Group_3__0)
	{ after(grammarAccess.getSwitchCaseAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SwitchCase__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchCase__Group_3__0__Impl
	rule__SwitchCase__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchCaseAccess().getColonKeyword_3_0()); }
	':'
	{ after(grammarAccess.getSwitchCaseAccess().getColonKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchCase__Group_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchCaseAccess().getThenAssignment_3_1()); }
	(rule__SwitchCase__ThenAssignment_3_1)
	{ after(grammarAccess.getSwitchCaseAccess().getThenAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnExpression__Group__0__Impl
	rule__ReturnExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnExpressionAccess().getReturnExpressionAction_0()); }
	()
	{ after(grammarAccess.getReturnExpressionAccess().getReturnExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnExpression__Group__1__Impl
	rule__ReturnExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnExpressionAccess().getReturnKeyword_1()); }
	'return'
	{ after(grammarAccess.getReturnExpressionAccess().getReturnKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnExpressionAccess().getExpressionAssignment_2()); }
	(rule__ReturnExpression__ExpressionAssignment_2)
	{ after(grammarAccess.getReturnExpressionAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InitializationExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__0__Impl
	rule__InitializationExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0()); }
	()
	{ after(grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__1__Impl
	rule__InitializationExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__2__Impl
	rule__InitializationExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getGroup_2()); }
	(rule__InitializationExpression__Group_2__0)?
	{ after(grammarAccess.getInitializationExpressionAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InitializationExpression__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2__0__Impl
	rule__InitializationExpression__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_0()); }
	(rule__InitializationExpression__ArgumentsAssignment_2_0)
	{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getGroup_2_1()); }
	(rule__InitializationExpression__Group_2_1__0)*
	{ after(grammarAccess.getInitializationExpressionAccess().getGroup_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InitializationExpression__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2_1__0__Impl
	rule__InitializationExpression__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0()); }
	','
	{ after(grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_1_1()); }
	(rule__InitializationExpression__ArgumentsAssignment_2_1_1)
	{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BlockExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BlockExpression__Group__0__Impl
	rule__BlockExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockExpressionAccess().getBlockExpressionAction_0()); }
	()
	{ after(grammarAccess.getBlockExpressionAccess().getBlockExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BlockExpression__Group__1__Impl
	rule__BlockExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockExpressionAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getBlockExpressionAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BlockExpression__Group__2__Impl
	rule__BlockExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockExpressionAccess().getExpressionsAssignment_2()); }
	(rule__BlockExpression__ExpressionsAssignment_2)*
	{ after(grammarAccess.getBlockExpressionAccess().getExpressionsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BlockExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockExpressionAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getBlockExpressionAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__0__Impl
	rule__Argument__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getGroup_0()); }
	(rule__Argument__Group_0__0)?
	{ after(grammarAccess.getArgumentAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__1__Impl
	rule__Argument__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getGroup_1()); }
	(rule__Argument__Group_1__0)?
	{ after(grammarAccess.getArgumentAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getValueAssignment_2()); }
	(rule__Argument__ValueAssignment_2)
	{ after(grammarAccess.getArgumentAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_0__0__Impl
	rule__Argument__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getParameterAssignment_0_0()); }
	(rule__Argument__ParameterAssignment_0_0)
	{ after(grammarAccess.getArgumentAccess().getParameterAssignment_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1()); }
	'='
	{ after(grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getGroup_1_0()); }
	(rule__Argument__Group_1_0__0)
	{ after(grammarAccess.getArgumentAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_1_0__0__Impl
	rule__Argument__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getKeyAssignment_1_0_0()); }
	(rule__Argument__KeyAssignment_1_0_0)
	{ after(grammarAccess.getArgumentAccess().getKeyAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getColonKeyword_1_0_1()); }
	':'
	{ after(grammarAccess.getArgumentAccess().getColonKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParenthesizedExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__0__Impl
	rule__ParenthesizedExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0()); }
	()
	{ after(grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__1__Impl
	rule__ParenthesizedExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1()); }
	'('
	{ after(grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__2__Impl
	rule__ParenthesizedExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getExpressionAssignment_2()); }
	(rule__ParenthesizedExpression__ExpressionAssignment_2)
	{ after(grammarAccess.getParenthesizedExpressionAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3()); }
	')'
	{ after(grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group__0__Impl
	rule__TypeSpecifier__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getTypeAssignment_0()); }
	(rule__TypeSpecifier__TypeAssignment_0)
	{ after(grammarAccess.getTypeSpecifierAccess().getTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1()); }
	(rule__TypeSpecifier__Group_1__0)?
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1_0()); }
	(rule__TypeSpecifier__Group_1_0__0)
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0__0__Impl
	rule__TypeSpecifier__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0()); }
	'<'
	{ after(grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0__1__Impl
	rule__TypeSpecifier__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1()); }
	(rule__TypeSpecifier__Group_1_0_1__0)?
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2()); }
	'>'
	{ after(grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1__0__Impl
	rule__TypeSpecifier__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_0()); }
	(rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_0)
	{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1_1()); }
	(rule__TypeSpecifier__Group_1_0_1_1__0)*
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1_1__0__Impl
	rule__TypeSpecifier__Group_1_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0()); }
	','
	{ after(grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_1_1()); }
	(rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_1_1)
	{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__QID__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group__0__Impl
	rule__QID__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getIDTerminalRuleCall_0()); }
	RULE_ID
	{ after(grammarAccess.getQIDAccess().getIDTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getGroup_1()); }
	(rule__QID__Group_1__0)*
	{ after(grammarAccess.getQIDAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__QID__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group_1__0__Impl
	rule__QID__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getFullStopKeyword_1_0()); }
	('.')
	{ after(grammarAccess.getQIDAccess().getFullStopKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1()); }
	RULE_ID
	{ after(grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BoolLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BoolLiteral__Group__0__Impl
	rule__BoolLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0()); }
	()
	{ after(grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BoolLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBoolLiteralAccess().getValueAssignment_1()); }
	(rule__BoolLiteral__ValueAssignment_1)
	{ after(grammarAccess.getBoolLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntLiteral__Group__0__Impl
	rule__IntLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntLiteralAccess().getIntLiteralAction_0()); }
	()
	{ after(grammarAccess.getIntLiteralAccess().getIntLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntLiteralAccess().getValueAssignment_1()); }
	(rule__IntLiteral__ValueAssignment_1)
	{ after(grammarAccess.getIntLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DoubleLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoubleLiteral__Group__0__Impl
	rule__DoubleLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0()); }
	()
	{ after(grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoubleLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoubleLiteralAccess().getValueAssignment_1()); }
	(rule__DoubleLiteral__ValueAssignment_1)
	{ after(grammarAccess.getDoubleLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FloatLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FloatLiteral__Group__0__Impl
	rule__FloatLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0()); }
	()
	{ after(grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FloatLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFloatLiteralAccess().getValueAssignment_1()); }
	(rule__FloatLiteral__ValueAssignment_1)
	{ after(grammarAccess.getFloatLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__HexLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__HexLiteral__Group__0__Impl
	rule__HexLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getHexLiteralAccess().getHexLiteralAction_0()); }
	()
	{ after(grammarAccess.getHexLiteralAccess().getHexLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__HexLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getHexLiteralAccess().getValueAssignment_1()); }
	(rule__HexLiteral__ValueAssignment_1)
	{ after(grammarAccess.getHexLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BinaryLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BinaryLiteral__Group__0__Impl
	rule__BinaryLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0()); }
	()
	{ after(grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BinaryLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBinaryLiteralAccess().getValueAssignment_1()); }
	(rule__BinaryLiteral__ValueAssignment_1)
	{ after(grammarAccess.getBinaryLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StringLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StringLiteral__Group__0__Impl
	rule__StringLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStringLiteralAccess().getStringLiteralAction_0()); }
	()
	{ after(grammarAccess.getStringLiteralAccess().getStringLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StringLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStringLiteralAccess().getValueAssignment_1()); }
	(rule__StringLiteral__ValueAssignment_1)
	{ after(grammarAccess.getStringLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NullLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NullLiteral__Group__0__Impl
	rule__NullLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NullLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNullLiteralAccess().getNullLiteralAction_0()); }
	()
	{ after(grammarAccess.getNullLiteralAccess().getNullLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NullLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NullLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NullLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNullLiteralAccess().getNullKeyword_1()); }
	'null'
	{ after(grammarAccess.getNullLiteralAccess().getNullKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GeneratorModel__GeneratorIdAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratorModelAccess().getGeneratorIdGENERATOR_IDParserRuleCall_2_0()); }
		ruleGENERATOR_ID
		{ after(grammarAccess.getGeneratorModelAccess().getGeneratorIdGENERATOR_IDParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__PropertiesAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratorModelAccess().getPropertiesPropertyDefinitionParserRuleCall_4_0()); }
		rulePropertyDefinition
		{ after(grammarAccess.getGeneratorModelAccess().getPropertiesPropertyDefinitionParserRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorModel__EntriesAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratorModelAccess().getEntriesGeneratorEntryParserRuleCall_5_0()); }
		ruleGeneratorEntry
		{ after(grammarAccess.getGeneratorModelAccess().getEntriesGeneratorEntryParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__ConstAssignment_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getConstConstKeyword_0_0_0()); }
		(
			{ before(grammarAccess.getPropertyDefinitionAccess().getConstConstKeyword_0_0_0()); }
			'const'
			{ after(grammarAccess.getPropertyDefinitionAccess().getConstConstKeyword_0_0_0()); }
		)
		{ after(grammarAccess.getPropertyDefinitionAccess().getConstConstKeyword_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getPropertyDefinitionAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__TypeSpecifierAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getPropertyDefinitionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyDefinition__InitialValueAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyDefinitionAccess().getInitialValueExpressionParserRuleCall_5_0()); }
		ruleExpression
		{ after(grammarAccess.getPropertyDefinitionAccess().getInitialValueExpressionParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__KeywordAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratorEntryAccess().getKeywordIDTerminalRuleCall_0_0()); }
		RULE_ID
		{ after(grammarAccess.getGeneratorEntryAccess().getKeywordIDTerminalRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__ElementRefAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratorEntryAccess().getElementRefEObjectCrossReference_1_0()); }
		(
			{ before(grammarAccess.getGeneratorEntryAccess().getElementRefEObjectQIDParserRuleCall_1_0_1()); }
			ruleQID
			{ after(grammarAccess.getGeneratorEntryAccess().getElementRefEObjectQIDParserRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getGeneratorEntryAccess().getElementRefEObjectCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratorEntry__FeaturesAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratorEntryAccess().getFeaturesFeatureConfigurationParserRuleCall_3_0()); }
		ruleFeatureConfiguration
		{ after(grammarAccess.getGeneratorEntryAccess().getFeaturesFeatureConfigurationParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__TypeAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureConfigurationAccess().getTypeFeatureTypeCrossReference_2_0()); }
		(
			{ before(grammarAccess.getFeatureConfigurationAccess().getTypeFeatureTypeIDTerminalRuleCall_2_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFeatureConfigurationAccess().getTypeFeatureTypeIDTerminalRuleCall_2_0_1()); }
		)
		{ after(grammarAccess.getFeatureConfigurationAccess().getTypeFeatureTypeCrossReference_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureConfiguration__ParameterValuesAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureConfigurationAccess().getParameterValuesFeatureParameterValueParserRuleCall_4_0()); }
		ruleFeatureParameterValue
		{ after(grammarAccess.getFeatureConfigurationAccess().getParameterValuesFeatureParameterValueParserRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__ParameterAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureParameterValueAccess().getParameterFeatureParameterCrossReference_1_0()); }
		(
			{ before(grammarAccess.getFeatureParameterValueAccess().getParameterFeatureParameterIDTerminalRuleCall_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFeatureParameterValueAccess().getParameterFeatureParameterIDTerminalRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getFeatureParameterValueAccess().getParameterFeatureParameterCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureParameterValue__ExpressionAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureParameterValueAccess().getExpressionExpressionParserRuleCall_3_0()); }
		ruleExpression
		{ after(grammarAccess.getFeatureParameterValueAccess().getExpressionExpressionParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0()); }
		ruleAssignmentOperator
		{ after(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__ExpressionAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0()); }
		ruleConditionalExpression
		{ after(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__TrueCaseAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalOrExpression
		{ after(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__FalseCaseAssignment_1_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0()); }
		ruleLogicalOrExpression
		{ after(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalAndExpression
		{ after(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalNotExpression
		{ after(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__OperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0()); }
		ruleBitwiseOrExpression
		{ after(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0()); }
		ruleBitwiseXorExpression
		{ after(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0()); }
		ruleBitwiseAndExpression
		{ after(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalRelationExpression
		{ after(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0()); }
		ruleRelationalOperator
		{ after(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0()); }
		ruleShiftExpression
		{ after(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0()); }
		ruleShiftOperator
		{ after(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0()); }
		ruleNumericalAddSubtractExpression
		{ after(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0()); }
		ruleAdditiveOperator
		{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0()); }
		ruleNumericalMultiplyDivideExpression
		{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0()); }
		ruleMultiplicativeOperator
		{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0()); }
		ruleNumericalUnaryExpression
		{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0()); }
		ruleUnaryOperator
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__OperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0()); }
		rulePostFixUnaryExpression
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0()); }
		rulePostFixOperator
		{ after(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__TypeSpecifierAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__FeatureAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0()); }
		(
			{ before(grammarAccess.getFeatureCallAccess().getFeatureEObjectRefIDWithKeywordsParserRuleCall_1_0_1_0_1()); }
			ruleRefIDWithKeywords
			{ after(grammarAccess.getFeatureCallAccess().getFeatureEObjectRefIDWithKeywordsParserRuleCall_1_0_1_0_1()); }
		)
		{ after(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__OperationCallAssignment_1_0_2_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
		(
			{ before(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
			'('
			{ after(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
		)
		{ after(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArrayAccessAssignment_1_0_2_1_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
		(
			{ before(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
			'['
			{ after(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
		)
		{ after(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ReferenceAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0()); }
		(
			{ before(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectRefIDWithKeywordsParserRuleCall_1_0_1()); }
			ruleRefIDWithKeywords
			{ after(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectRefIDWithKeywordsParserRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__OperationCallAssignment_2_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
		(
			{ before(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
			'('
			{ after(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
		)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArrayAccessAssignment_2_1_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
		(
			{ before(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
			'['
			{ after(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
		)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0()); }
		ruleLiteral
		{ after(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__ConditionAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIfExpressionAccess().getConditionExpressionParserRuleCall_3_0()); }
		ruleExpression
		{ after(grammarAccess.getIfExpressionAccess().getConditionExpressionParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__ThenAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIfExpressionAccess().getThenBlockExpressionParserRuleCall_5_0()); }
		ruleBlockExpression
		{ after(grammarAccess.getIfExpressionAccess().getThenBlockExpressionParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfExpression__ElseAssignment_6_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIfExpressionAccess().getElseBlockExpressionParserRuleCall_6_1_0()); }
		ruleBlockExpression
		{ after(grammarAccess.getIfExpressionAccess().getElseBlockExpressionParserRuleCall_6_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__SwitchAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSwitchExpressionAccess().getSwitchExpressionOrBlockExpressionParserRuleCall_3_0()); }
		ruleExpressionOrBlockExpression
		{ after(grammarAccess.getSwitchExpressionAccess().getSwitchExpressionOrBlockExpressionParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__CasesAssignment_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSwitchExpressionAccess().getCasesSwitchCaseParserRuleCall_6_0()); }
		ruleSwitchCase
		{ after(grammarAccess.getSwitchExpressionAccess().getCasesSwitchCaseParserRuleCall_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchExpression__DefaultAssignment_7_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSwitchExpressionAccess().getDefaultExpressionOrBlockExpressionParserRuleCall_7_2_0()); }
		ruleExpressionOrBlockExpression
		{ after(grammarAccess.getSwitchExpressionAccess().getDefaultExpressionOrBlockExpressionParserRuleCall_7_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__CaseAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSwitchCaseAccess().getCaseExpressionParserRuleCall_2_0()); }
		ruleExpression
		{ after(grammarAccess.getSwitchCaseAccess().getCaseExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchCase__ThenAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSwitchCaseAccess().getThenExpressionOrBlockExpressionParserRuleCall_3_1_0()); }
		ruleExpressionOrBlockExpression
		{ after(grammarAccess.getSwitchCaseAccess().getThenExpressionOrBlockExpressionParserRuleCall_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnExpression__ExpressionAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnExpressionAccess().getExpressionConditionalExpressionParserRuleCall_2_0()); }
		ruleConditionalExpression
		{ after(grammarAccess.getReturnExpressionAccess().getExpressionConditionalExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__ArgumentsAssignment_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0()); }
		ruleArgument
		{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__ArgumentsAssignment_2_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockExpression__ExpressionsAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBlockExpressionAccess().getExpressionsExpressionParserRuleCall_2_0()); }
		ruleExpression
		{ after(grammarAccess.getBlockExpressionAccess().getExpressionsExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__ParameterAssignment_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0()); }
		(
			{ before(grammarAccess.getArgumentAccess().getParameterTypedDeclarationIDTerminalRuleCall_0_0_0_1()); }
			RULE_ID
			{ after(grammarAccess.getArgumentAccess().getParameterTypedDeclarationIDTerminalRuleCall_0_0_0_1()); }
		)
		{ after(grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__KeyAssignment_1_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0()); }
		rulePrimitiveValueExpression
		{ after(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__ValueAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0()); }
		ruleConditionalExpression
		{ after(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__ExpressionAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0()); }
		ruleExpression
		{ after(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__TypeAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0()); }
		(
			{ before(grammarAccess.getTypeSpecifierAccess().getTypeTypeQIDParserRuleCall_0_0_1()); }
			ruleQID
			{ after(grammarAccess.getTypeSpecifierAccess().getTypeTypeQIDParserRuleCall_0_0_1()); }
		)
		{ after(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0()); }
		RULE_BOOL
		{ after(grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0()); }
		RULE_LONG
		{ after(grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0()); }
		RULE_DOUBLE
		{ after(grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0()); }
		RULE_FLOAT
		{ after(grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0()); }
		RULE_HEX
		{ after(grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0()); }
		RULE_BINARY
		{ after(grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_LONG : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_BOOL : ('true'|'false'|'yes'|'no');

RULE_HEX : '0' ('x'|'X') ('0'..'9'|'a'..'f'|'A'..'F')+;

RULE_BINARY : '0' ('b'|'B') ('0'|'1')+;

RULE_DOUBLE : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('d'|'D')?;

RULE_FLOAT : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('f'|'F')?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
