/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.genmodel.ui.outline

import org.eclipse.xtext.ui.editor.outline.IOutlineNode
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider
import com.yakindu.base.base.NamedElement
import com.yakindu.sct.model.sgen.GeneratorEntry

/** 
 * customization of the default outline structure
 */
class SGenOutlineTreeProvider extends DefaultOutlineTreeProvider {

	def protected void _createNode(IOutlineNode parentNode, GeneratorEntry modelElement) {
		var String name = modelElement.keyword
		if (modelElement.getElementRef() instanceof NamedElement) {
			name = '''«name» «((modelElement.getElementRef() as NamedElement)).getName()»'''
		}
		createEObjectNode(parentNode, modelElement, imageDispatcher.invoke(modelElement), name,
			isLeafDispatcher.invoke(modelElement))
	}
}
