/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.genmodel.ui.templates

import com.google.inject.Inject
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.library.IDefaultFeatureValueProvider
import com.yakindu.sct.model.sgen.FeatureConfiguration
import com.yakindu.sct.model.sgen.FeatureParameter
import com.yakindu.sct.model.sgen.FeatureType
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.serializer.ISerializer

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SGenProposalCreator {
	@Inject extension ITypeSystem ts
	@Inject ISerializer serializer

	//TODO: Remove filter for 'ThreadSafeAccess' once it's supported publicly
	def createProposal(FeatureType featureType, IDefaultFeatureValueProvider valueProvider, EObject context) {
		var defaultConfiguration = valueProvider.createDefaultFeatureConfiguration(featureType, context)
		'''
			feature «featureType.name» {
				«FOR param : featureType.parameters.filter[!isDeprecated]»
					«IF !param.name.equals("ThreadSafeAccess")»«param.name» = «defaultConfiguration.value(param)»«ENDIF»
				«ENDFOR»
			}
		'''.toString
	}

	def value(FeatureConfiguration value, FeatureParameter param) {
		var defaultValue = value.getParameterValue(param.name)
		if (defaultValue !== null) {
			return serializer.serialize(defaultValue.expression)
		} else {
			if (param.parameterType.isString) {
				return "\"\""
			} else if (param.parameterType.isBoolean) {
				return false
			} else if (param.parameterType.isReal) {
				return 0.0
			} else if (param.parameterType.isInteger) {
				return 0l
			}
		}
		null
	}

}