package com.itemis.create.base.generator.core.codemodel

import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.Package
import com.itemis.create.base.generator.core.GeneratorAssignment

/**
 * Defines the code model concept of a general compilation unit. A compilation unit is a collection of declarations
 * which should be placed in a single source file. A compilation unit model element is a Package which is annotated as 
 * compilation unit. This concept definition provides a builder to create a properly defined element including generator assignment
 * and a query to check if a package element represents a compilation unit. 
 * 
 * Subclasses should override compilationUnitGenerator()
 * 
 * @author Axel Terfloth
 */
class CompilationUnit {
	
	public static final String COMPILATION_UNIT_ANNOTATION_NAME = "__compilation_unit__"
	
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected Namespace namespaceConcept
	
	def protected compilationUnitAnnotationName() {
		COMPILATION_UNIT_ANNOTATION_NAME
	}
	
	def _compilationUnit() {
		_package => [
			it._compilationUnit
		]
	}
	
	def _compilationUnit(Package it) {
		_no_namespace
		_annotate(compilationUnitAnnotationName)
		generateDefinitionWith[compilationUnitDefinitionGenerator]
		generateDeclarationWith[compilationUnitDeclarationGenerator]
	}
	
	def _compilationUnit(Package it, String namespace) {
		val extension namespaceConcept = provideNamespaceConcept
		
		if(namespace === null)
			return it._compilationUnit
		it._namespace
		name = namespace
		_annotate(compilationUnitAnnotationName)
		generateDefinitionWith[compilationUnitDefinitionGenerator]
		generateDeclarationWith[compilationUnitDeclarationGenerator]
	}

	def isCompilationUnit(Package it) {
		getAnnotationOfType(compilationUnitAnnotationName) !== null
	}
	
	def protected compilationUnitDefinitionGenerator(Package it) '''
		// no generator specified for compilation unit «name»
	'''
	
	def protected compilationUnitDeclarationGenerator(Package it) '''
		// no generator specified for compilation unit «name»
	'''
	
	
	def protected provideNamespaceConcept() {
		return namespaceConcept
	}
}