package com.itemis.create.base.generator.core.codemodel

import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EObject

/**
 * A separator is a expression level concepts. It can be applied to expressions like FeatureCall. 
 * This class supports attaching and retrieving this information. The implementation uses adapter on EObjects.
 */
class Separator {
	
	def <T extends EObject> T setSeparator(T it, String s) {
		return assignConcept(new Adapter(s))
	}
	
	def <T extends EObject> String getSeparator(T it) {
		assignedConcept(Adapter)?.separator
	}
	
	def <T extends EObject> boolean definesSeparator(T it) {
		assignedConcept(Adapter) !== null
	}
	
	def <S extends Adapter, T extends EObject> T assignConcept(T it, S adapter) {
		val existingAdapter = it?.eAdapters.filter(adapter.class).head
		
		if (existingAdapter !== null) {
			it.eAdapters.remove(existingAdapter);
		}
		
		it.eAdapters.add(adapter)	

		return it
	}	
	
	def  assignedConcept(EObject it, Class<? extends Adapter> clazz) {
		it?.eAdapters.filter(clazz).head
	}
	
	static class Adapter extends AdapterImpl {
		protected String separator
		
		new(String s) {
			separator = s
		}
		
		def String getSeparator() {
			return separator
		}
	}	
}