/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.codepattern

import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.BinaryExpression
import com.yakindu.base.expressions.expressions.BinaryLiteral
import com.yakindu.base.expressions.expressions.BlockExpression
import com.yakindu.base.expressions.expressions.BoolLiteral
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.DeclarationExpression
import com.yakindu.base.expressions.expressions.DoubleLiteral
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.HexLiteral
import com.yakindu.base.expressions.expressions.IfExpression
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.Literal
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.ParenthesizedExpression
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.ReturnExpression
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.base.expressions.expressions.TryExpression
import com.yakindu.base.expressions.expressions.UnaryExpression
import com.yakindu.base.expressions.expressions.VerbatimExpression
import com.yakindu.base.expressions.expressions.WhileExpression
import com.yakindu.base.types.Argument
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Parameter
import java.util.List
import org.eclipse.xtext.util.Strings

/**
 * This expressions generator generates expressions according to the common C like syntax which is also applied by C++, C#, Java and other target langauges.
 * This is type system independent, thus this class can be also used to serialize / generate string from the base types and expressions (e.g. based on the code model)
 * 
 * @author Axel Terfloth - Initial contribution and API
 */
class BaseExpressionCode {
	def dispatch CharSequence code(Expression it) {
		throw new IllegalStateException("No dispatch function for " + getClass().name)
	}
	
	def dispatch CharSequence code(Literal it) {
		throw new IllegalStateException("No dispatch function for " + getClass().name)
	}
	
	def dispatch CharSequence code(BinaryExpression it) {
		'''(«leftOperand.code.toString.trim» «operator.literal.toString.trim» «rightOperand.code»)'''
	}

	def dispatch CharSequence code(UnaryExpression it) {
		operator.literal + '''(«operand.code»)'''
	}

	def dispatch CharSequence code(PostFixUnaryExpression it) {
		operand.code + operator.literal
	}
	
	def dispatch CharSequence code(AssignmentExpression it) {
		'''«varRef.code» «operator.literal» «expression.code»'''
	}
	
	def dispatch CharSequence code(InitializationExpression it) {
		'''{ «FOR a : arguments SEPARATOR ', '»«IF a.value !== null»«a.code»«ENDIF»«ENDFOR» }'''
	}
	
	def dispatch CharSequence code(ConditionalExpression it) '''«condition.code» ? «trueCase.code» : «falseCase.code»'''

	def dispatch CharSequence code(PrimitiveValueExpression it) '''«value.code»'''

	def dispatch CharSequence code(ParenthesizedExpression it) '''(«expression.code»)'''
	
	def dispatch CharSequence code(Argument it) {
		'''«IF key !== null»«key.code» : «ENDIF»«value.code»'''
	}

	/**
	 * TODO: Remove dependency to org.eclipse.xtext.util.Strings
	 */
	def dispatch CharSequence code(StringLiteral it) '''"«Strings.convertToJavaString(value.escaped)»"'''

	def protected String escaped(String it) {
		return it.replace("\"", "\\\"");
	}

	def dispatch CharSequence code(IntLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(DoubleLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(FloatLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(HexLiteral it) '''0x«Long::toHexString(value)»'''

	def dispatch CharSequence code(BinaryLiteral it) '''0b«Long::toBinaryString(value)»'''

	def dispatch CharSequence code(BoolLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(NullLiteral expression) {
		'null'
	}
	
	def dispatch CharSequence code(ElementReferenceExpression it) 
		'''«reference.symbol»«IF isOperationCall»(«argCode»)«ELSEIF isArrayAccess»«FOR a : arraySelector»[«a.code»]«ENDFOR»«ENDIF»'''

	def dispatch CharSequence code(FeatureCall it) 
		'''«owner.code».«feature.symbol»«IF isOperationCall»(«argCode»)«ENDIF»'''	
			
	def dispatch CharSequence code(BlockExpression it) '''
		{
			«FOR e : expressions»
				 «e.statement»
			«ENDFOR»
		}'''

	def dispatch CharSequence code(DeclarationExpression it) {
		it.code(declaration)
	}
	
	def dispatch CharSequence code(Expression it, Object target) ''''''
	
	def dispatch CharSequence code(DeclarationExpression it, Declaration prop) 
		'''// can't generate declaration of type «prop.class.name»'''
	
	def dispatch CharSequence code(ReturnExpression it) 
		'''return«IF expression !== null» «expression.code»«ENDIF»'''
	

	def dispatch CharSequence code(WhileExpression it) 
		'''while ( «condition.code» ) «body.code»'''
		
	def dispatch CharSequence code(TimeEventSpec it) 
		'''«type.getName» «value.code» «getUnit.getName»'''


	def dispatch CharSequence code(IfExpression it) 
		'''if ( «condition.code» ) «then.code»«IF ^else !== null» else «^else.code»«ENDIF»'''
		
	def dispatch CharSequence code(TryExpression it)'''
		try
		«^try.code»
		«IF ^catch !== null» catch «IF exception !== null»(«exception.code»)«ENDIF»
		«^catch.code»
		«ENDIF»
		«IF ^finally !== null»finally 
		«^finally.code»
		«ENDIF»'''
		

	def dispatch code(VerbatimExpression it) {
		'''«code»'''
	}

	def dispatch CharSequence statement(Expression it) '''
		«code»;
	'''
	
	
	def dispatch CharSequence statement(TryExpression it) '''
		«code»
	'''
	
	
	protected def CharSequence argCode(ArgumentExpression it) {
		'''«FOR arg : expressions SEPARATOR ', '»«arg.code»«ENDFOR»'''
	}
	
	protected def CharSequence paramCode(List<Parameter> it) {
		'''«FOR p : it SEPARATOR ', '»«p.name»«ENDFOR»'''
	}
		
	protected def dispatch symbol(NamedElement it) '''«name»'''
	protected def dispatch symbol(Object it) '''/* No symbol resolvable for element of type «it.class.name» */'''
}