/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.base.expressions.expressions.DeclarationExpression
import com.yakindu.base.expressions.expressions.TypeCastExpression
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeSpecifier

/**
 * This expressions generator generates expressions according to the common C like syntax which is also applied by C++, C#, Java and other target langauges.
 * Specific code generator should extend this implementation.
 * 
 * @author Axel Terfloth - Initial contribution and API
 */
class TypeSystemAccessExpressionCode extends BaseExpressionCode{
	
	@Inject protected extension ICodegenTypeSystemAccess
	

	def dispatch CharSequence code(TypeCastExpression it) '''((«typeSpecifier.getTargetLanguageName») «operand.code»)'''
	
	
	def dispatch CharSequence code(DeclarationExpression it, Property prop) 
		'''«prop.type.targetLanguageName» «prop.name»«IF prop.initialValue !== null» = «prop.initialValue.code»«ENDIF»'''
		
	def dispatch code(TypeSpecifier it) 
		'''«targetLanguageName»«IF !it.typeArguments.empty»<«FOR t : typeArguments SEPARATOR ', '»«t.code»«ENDFOR»>«ENDIF»'''
		
	
}