/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.sctunit.generator.csharp.features

import com.itemis.create.base.generator.csharp.features.CsharpFeatureTypeLibraryProvider

import static com.yakindu.base.types.typesystem.ITypeSystem.BOOLEAN

class CsharpSGenFeatureTypeLibraryProvider extends CsharpFeatureTypeLibraryProvider {
	
	

	override provide() {
		createFeatureTypeLibrary => [
			name = "SCTUnit C# Generator"
			types += outlet()
			types += licenseHeader()
			types += debug()
			types += functionInlining()
			types += outEventAPI()
			types += naming()
			types += csharpFeatures()
		]
	}
	
	override outEventAPI() {
		createFeatureType => [
			name = "OutEventAPI"
			optional = true
			parameters += createFeatureParameter => [
				name = "getters"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}
}
