/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class PackageInit {
	
	@Inject	extension Naming 
	@Inject	extension OutputConfigProvider
	
	
	def generatePyPackageInit(IFileSystemAccess fsa, String path, GeneratorEntry entry) {
		generatePyPackageInit(fsa, path, entry.defaultOutputConfig, entry)
	}

	def generatePyPackageInit(IFileSystemAccess fsa, String path, String outputConfig, GeneratorEntry entry) {
		var targetPath = ""
		for (segment : path.split("/")) {
			targetPath = targetPath + "/" + segment
			fsa.generateFile(targetPath + '/' + "__init__".py, outputConfig, content(entry))
		}
	}
	
	def content(GeneratorEntry entry) {
		'''
			"""
			
			Empty file that initializes the package it is contained in.
			
			"""
		'''
	}
}
