/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.python.files

import com.google.inject.Inject
import com.yakindu.sct.generator.python.GenmodelEntries
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class PyPSetup {
	
	@Inject extension GenmodelEntries
	@Inject extension Naming
	@Inject extension SExecExtensions
	
	def generatePythonPackagingSetup(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		// setup.py
		fsa.generateFile(entry.basePackagePath + '/' + 'setup'.py, contentSetupFile(flow, entry))
		// Manifest.in
		fsa.generateFile(entry.basePackagePath + '/' + 'MANIFEST.in', contentManifest())
		// License.txt
		fsa.generateFile(entry.basePackagePath + '/' + 'LICENSE.txt', contentLicense(entry))
		// Readme.rst
		fsa.generateFile(entry.basePackagePath + '/' + 'README.rst', contentReadMe(flow))
	}
	
	def private contentSetupFile(ExecutionFlow flow, GeneratorEntry entry)'''
		from distutils.core import setup
		
		with open('README.rst') as f:
			readme = f.read()
			
		with open('LICENSE.txt') as f:
			license = f.read()
		
		setup(
			name = '«flow.statemachineName»',
			version = '«entry.pyPackageVersion»',
			author = '«entry.pyPackageAuthor»',
			packages = [«flow.statemachineName.toLowerCase»,],
			#scripts = [],
			#url = «entry.pyPackageURL»«flow.statemachineName»',
			license = license,
			description='«entry.pyPackageDescription»',
			long_description = readme,
			#install_requires = [
			#	"django >= 1.1.1",
			#	"caldav == 0.1.4",
			#],
		)
	'''
	
	def private contentManifest()'''
		include *.txt
		recursive-include docs *.txt
	'''
	
	def private contentLicense(GeneratorEntry entry)'''
		«entry.pyPackageLicense»
	'''
	
	def private contentReadMe(ExecutionFlow flow)'''
		========
		«flow.statemachineName»
		========
		
		Short description of your project / statemachine.
		
		Short description of usage:
		
			#!/usr/bin/env python
			
			import «flow.statemachineName.toLowerCase»
			«IF flow.timed»
				from «flow.statemachineName.toLowerCase».timer import sct.timer 
			«ENDIF»
		
		Paragraphs are separated by blank lines. *Italic*, **bold**, and
		``monospace`` look like this.
		
		A Section
		=========
		
		List look like this:
		
		* First
		
		* Second. Can be multiple lines
		  but must be indented properly.
		  
		 A Sub-Section
		 -------------
		 
		 Numbered lists look like you'd expect:
		 
		 1. first
		 
		 2. second
		 
		 URLs are http://like.this and links can be
		 written `like this <http:// www.example.com/foo/bar>`_.
		 
		 Contributers
		 ============
		 
		 name someone.
	'''
}
