/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.submodules

/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.python.PythonExpressionsGenerator
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sct.model.sgraph.util.StatechartUtil

class ScopeGenerator {

	@Inject extension PythonExpressionsGenerator
	@Inject extension Naming
	@Inject extension SExecExtensions
	@Inject extension ICoreLibraryHelper
	@Inject extension ShadowEventExtensions
	@Inject extension StatechartUtil
	
	@Inject GeneratorEntry entry

	def interfaceScopeClass(InterfaceScope scope, ExecutionFlow flow) '''
		class «scope.interfaceTypeName»:
			"""Implementation of scope «scope.interfaceTypeName».
			"""
			
			«scope.constructor»
			«scope.methods»
		
	'''

	protected def constructor(InterfaceScope scope) '''
		def __init__(self, statemachine):
			«scope.properties»
			self.statemachine = statemachine
		
	'''
	
	def methods(StatechartScope scope) '''
		«scope.variableMethods»
		«scope.eventMethods»
	'''
	
	def properties(StatechartScope scope) '''
		«scope.variableProperties»
		«scope.eventProperties»
		«scope.operationCallbackProperty»
		
	'''
		
	
	protected def variableProperties(StatechartScope scope) '''
		«FOR variable : scope.variableDefinitions»
			«IF !variable.const»
				«variable.variableProperty»
			«ELSE»
				«variable.constantProperty»
			«ENDIF»
		«ENDFOR»
	'''
	
	protected def variableProperty(VariableDefinition variable) '''
		self.«IF variable.type.isMultiSM»__«ENDIF»«variable.identifier» = None
	'''
	
	protected def constantProperty(VariableDefinition variable) '''
		self.«variable.identifier.toUpperCase» = «variable.initialValue.code»
	'''

	protected def dispatch variableMethods(InterfaceScope scope) '''
		«FOR variable : scope.variableDefinitions»
			«IF variable.needsAssignMethod»
				def «variable.assign»(self, value):
					"""Assign method for «variable.identifier».
					"""
					self.«variable.identifier.toLowerCase» = value
					return self.«variable.identifier.toLowerCase»
				
			«ENDIF»
			«IF variable.needsShadowEventMapping»
				@property
				def «variable.name.asEscapedName»(self):
					"""Property for «variable.identifier».
					"""
					return self.__«variable.identifier»
				
				@«variable.name.asEscapedName».setter
				def «variable.name.asEscapedName»(self, value):
					"""Setter for «variable.identifier».
					"""
					«variable.observerHandler("unsubscribe")»
					self.__«variable.identifier» = value
					«variable.observerHandler("subscribe")»
				
			«ENDIF»
		«ENDFOR»
	'''
	
	protected def dispatch variableMethods(InternalScope scope) '''
		«FOR variable : scope.variableDefinitions»
			«IF variable.needsAssignMethod»
				def «variable.assign»(self, value):
					"""Assign method for «variable.identifier».
					"""
					self.«variable.identifier.toLowerCase» = value
					return self.«variable.identifier.toLowerCase»
					
			«ENDIF»
			«IF variable.needsShadowEventMapping»
				@property
				def __«variable.name.asEscapedName»(self):
					"""Property for «variable.identifier».
					"""
					return self.__«variable.identifier»
				
				@__«variable.name.asEscapedName».setter
				def __«variable.name.asEscapedName»(self, value):
					"""Setter for «variable.identifier».
					"""
					«variable.observerHandler("unsubscribe")»
					self.__«variable.identifier» = value
					«variable.observerHandler("subscribe")»
				
			«ENDIF»
		«ENDFOR»
		
	'''
	
	protected def observerHandler(VariableDefinition variable, String subscription)'''
		«IF variable.needsShadowEventMapping»
			if self.«variable.identifier» is not None:
				«FOR shadowEvent : variable.shadowEvents»
					self.«variable.identifier».«shadowEvent.getOutEvent.shadowEventContext»«shadowEvent.getOutEvent.asObservable».«subscription»(self.«variable.statemachine»«shadowEvent.asObserver»)
				«ENDFOR»
		«ENDIF»
	'''

	protected def eventProperties(StatechartScope scope) '''
		«FOR event : scope.eventDefinitions»
			self.«event.identifier» = None
			«IF event.hasValue»
				self.«event.valueIdentifier» = None
			«ENDIF»
			«IF event.direction == Direction.OUT && entry.outEventObservablesUsed»
				self.«event.asObservable» = Observable()
			«ENDIF»
		«ENDFOR»
	'''

	protected def dispatch eventMethods(InterfaceScope scope) '''
		«FOR event : scope.eventDefinitions»
			«IF event.direction == Direction::IN»
				«event.inEventMethod»
			«ENDIF»
			«IF event.direction == Direction::OUT»
				«event.outEventMethod»
			«ENDIF»
		«ENDFOR»
	'''
	
	protected def dispatch eventMethods(InternalScope scope) '''
		«FOR event : scope.eventDefinitions»
			«IF event.direction == Direction::IN»
				«event.inEventMethod»
			«ELSE»
				«event.localEventMethod»
			«ENDIF»
		«ENDFOR»
	'''

	protected def inEventMethod(EventDefinition it) '''
		«IF hasValue»
			def «raiseFunctionName»(self, value):
				"""Raise method for event «identifier».
				"""
				self.«identifier» = True
				self.«valueIdentifier» = value
				
		«ELSE»
			def «raiseFunctionName»(self):
				"""Raise method for event «identifier».
				"""
				self.«identifier» = True
				
		«ENDIF»
	'''
	
	protected def localEventMethod(EventDefinition it) '''
		«inEventMethod»
	'''

	protected def outEventMethod(EventDefinition it) '''
		«IF entry.getOutEventGettersUsed»
			def «isRaisedFunctionName»(self):
				"""Cheks if «identifier» is raised.
				"""
				return self.«identifier»
			
		«ENDIF»
	'''
	
	protected def operationCallbackProperty(StatechartScope scope) '''
		«IF scope.hasOperations»
			self.«scope.operationCallbackInstance» = None
		«ENDIF»
	'''
	
		
	protected def statemachine(Declaration it) {
		if (isInNamedInterface)
			"statemachine."
		else
			""
	}

}
