/**
 * Copyright (c) 2016-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Thomas Kutz - itemis AG
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sct.domain.c.runtime.exec

import com.google.inject.Inject
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.interpreter.context.BuiltInTypeContextInitializer
import com.yakindu.base.expressions.interpreter.context.IExecutionContextInitializer
import com.yakindu.base.types.TypedElement
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.sct.model.sruntime.SRuntimeFactory
import org.eclipse.xtext.naming.IQualifiedNameProvider

class CBuiltInTypeContextInitializer extends BuiltInTypeContextInitializer {

	protected extension SRuntimeFactory factory = SRuntimeFactory.eINSTANCE

	@Inject extension ITypeSystemInferrer
	@Inject extension IQualifiedNameProvider

	def createSlotForWeak_ptr(TypedElement it, IExecutionContextInitializer initializer) {
		createSlotForPointer(initializer)
	}

	def createSlotForUnique_ptr(TypedElement it, IExecutionContextInitializer initializer) {
		createSlotForPointer(initializer)
	}

	def createSlotForShared_ptr(TypedElement it, IExecutionContextInitializer initializer) {
		createSlotForPointer(initializer)
	}

	def createSlotForPointer(TypedElement element, IExecutionContextInitializer initializer) {
		return createReferenceSlot => [
			type = element.infer.bindings.head?.type
			name = (element as NamedElement).name
			fqName = element.fullyQualifiedName.toString
			writable = false
		]
	}

}
