/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource

import com.google.inject.Inject
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier
import com.yakindu.base.types.typesystem.ITypeSystem

import static com.yakindu.sct.generator.c.typesystem.CTypeSystem.*
import static org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier.*
import static com.yakindu.base.types.typesystem.ITypeSystem.*
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier

class C99StdTypeMapper implements ISimpleTypeMapper {

	@Inject
	extension ITypeSystem

	override map(IASTNamedTypeSpecifier it) {
		return switch(it) {
			case name.toString == "size_t": getType(INTEGER)
			case name.toString == "ptrdiff_t": getType(INTEGER)
		}
	}
	
	def intType(IASTSimpleDeclSpecifier it) {
		if (unsigned) {
			return getType(UNSIGNED_INTEGER)
		}
		getType(INTEGER)
	}

	override map(IASTSimpleDeclSpecifier it) {
		return switch (it) {
			// default types
			case type == t_void: getType(VOID)
			case type == t_double: getType(DOUBLE)
			case type == t_float: getType(FLOAT)
			case type == t_bool: getType(BOOL)
			
			case type == t_char: intType

			case isShort: intType
			case isLong: intType
			case isLongLong: intType
			case type == t_int: intType
			
			case type == t_unspecified: intType
			
			/* Exact-width integer types */
//		typedef signed char int8_t;
//			case type == t_char && signed: getType(INT8_T)
//		typedef short int16_t;
//			case type == short: getType(INT16_T)
//		typedef int int32_t;
//			case type == t_int: getType(INT32_T)
//		typedef long long int64_t;
//			case type == longLong: getType("int64_t")
//		typedef unsigned char uint8_t;
//			case type == t_char && unsigned: getType(UINT8_T)
//		typedef unsigned short uint16_t;
//			case type == short && unsigned: getType(UINT16_T)
//		typedef unsigned int uint32_t;
//			case type == t_int && unsigned: getType(UINT32_T)
//		typedef unsigned long long uint64_t;
//		
//		/* Minimum-width integer types */
//		
//		typedef signed char int_least8_t;
//		typedef short int_least16_t;
//		typedef int int_least32_t;
//		typedef long long int_least64_t;
//		
//		typedef unsigned char uint_least8_t;
//		typedef unsigned short uint_least16_t;
//		typedef unsigned int uint_least32_t;
//		typedef unsigned long long uint_least64_t;
//		
//		/* Fastest minimum-width integer types */
//		
//		typedef signed char int_fast8_t;
//		typedef int int_fast16_t;
//		typedef int int_fast32_t;
//		typedef long long int_fast64_t;
//		
//		typedef unsigned char uint_fast8_t;
//		typedef unsigned int uint_fast16_t;
//		typedef unsigned int uint_fast32_t;
//		typedef unsigned long long uint_fast64_t;
//		
//		/* Integer types capable of holding object pointers */
//		
//		typedef int intptr_t;
//		typedef unsigned int uintptr_t;
//		
//		/* Greatest-width integer types */
//		
//		typedef long long intmax_t;
//		typedef unsigned long long uintmax_t;
		}
	}
	
	override mapTypeSpecifier(IASTNamedTypeSpecifier it) {
		throw new UnsupportedOperationException("TypeSpecifiers shouldn't be mapped using C++98, only C++11")
	}

}
