/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
 package com.yakindu.sct.domain.c.runtime.resource.headless

import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource
import com.yakindu.sct.domain.c.runtime.resource.transform.ProxyBuilder
import org.eclipse.cdt.core.dom.ast.IASTNameOwner
import org.eclipse.emf.common.util.URI
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypesPackage
/**
 * https://github.com/Yakindu/sctpro/issues/2042
 */
class HeadlessProxyBuilder extends ProxyBuilder {

	override Type createTypeProxy(CHeaderResource it, String pathToDeclaringHeader, IASTNameOwner declSpecifier) {
		return createProxy(TypesPackage.Literals.TYPE,
			createProxyURI(declSpecifier.name, URI::createFileURI(pathToDeclaringHeader)).appendQuery(
				getURI()?.query)) as Type
	}

	override createComplexTypeProxy(CHeaderResource it, String pathToDeclaringHeader, IASTNameOwner declSpecifier) {
		return createProxy(TypesPackage.Literals.COMPLEX_TYPE,
			createProxyURI(declSpecifier.name, URI::createFileURI(pathToDeclaringHeader)).appendQuery(
				getURI()?.query)) as Type
	}
}
