/**
 * Copyright (c) 2020-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.transform.types

import com.google.inject.Inject
import com.yakindu.base.types.PrimitiveType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.domain.c.runtime.resource.CFileLocationAdapter
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource
import com.yakindu.sct.domain.c.runtime.resource.transform.TypeScope
import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeNaming
import com.yakindu.sct.domain.c.runtime.resource.transform.c.CTypeUtils
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier
import org.eclipse.xtend.lib.annotations.Accessors
import com.yakindu.base.types.annotations.TypeAnnotations

/**
 * @author rbeckmann
 *
 */
class TypeCreationHandler extends TypeHandler implements IResourceOwner, ITypeScopeOwner {
	@Inject protected extension CTypeNaming
	@Inject protected extension CTypeUtils
	@Inject protected extension TypeBuilder
	@Inject protected extension TypeAnnotations
	@Inject protected extension ITypeSystem
	
	protected extension TypesFactory = TypesFactory.eINSTANCE
	
	@Accessors(PUBLIC_SETTER) protected TypeScope typeScope
	@Accessors(PUBLIC_SETTER) protected CHeaderResource resource
	
	override protected handle(IASTDeclSpecifier declSpecifier) {
		val t = createType(declSpecifier)
		t
	}
	
	/**
	 * This interface represents enumerations in C and C++.
	 */
	def protected dispatch create type : createEnumerationType createType(IASTEnumerationSpecifier declSpecifier) {
		type.name = name(declSpecifier)
		declSpecifier.enumerators.forEach[literal, index|type.enumerator += literal.enumLiteral(type)]
		type.eAdapters.add(new CFileLocationAdapter(declSpecifier.fileLocation))
		type.visible = declSpecifier.visible
		type.superTypes += createTypeSpecifier => [type = (getType(ITypeSystem.INTEGER) as PrimitiveType)];
		if (!declSpecifier.isTypedef) type._annotate(CTypeAnnotations.C_ENUM_ANNOTATION_TYPE)
		typeScope.put(declSpecifier.qualifiedName, type)
	}

	/**
	 * A composite type specifier represents a composite structure (union or struct that contains declarations).
	 * These types are always handled as value types.
	 */
	def protected dispatch create type : createComplexType createType(IASTCompositeTypeSpecifier declSpecifier) {
		type.name = name(declSpecifier)
		type.declareAsValueType
		type.eAdapters.add(new CFileLocationAdapter(declSpecifier.fileLocation))
		type.visible = declSpecifier.visible
		if (!declSpecifier.isTypedef && declSpecifier.isStruct)
		 type._annotate(CTypeAnnotations.C_STRUCT_ANNOTATION_TYPE)
		if (type.name.isBuiltInType)
		 type._annotate(createBuiltInTypeAnnotationType)
		if (declSpecifier.isUnion){
			if(!declSpecifier.isTypedef)
				type._annotate(CTypeAnnotations.C_UNION_ANNOTATION_TYPE)
			else
				type.superTypes += createTypeSpecifier => [ ts |
					ts.type = createComplexType => [
						name = CTypeAnnotations.C_UNION_ANNOTATION
						_annotate(CTypeAnnotations.C_UNION_ANNOTATION_TYPE)
					]
				] 
		} 
		typeScope.put(declSpecifier.qualifiedName, type)
	}
	
	def protected dispatch createType(IASTDeclSpecifier declSpecifier) {
		null
	}
	
	def protected create createEnumerator enumLiteral(IASTEnumerationSpecifier.IASTEnumerator enumerator, Type owningEnumType) {
		name = enumerator.name.toString
		typeSpecifier = createTypeSpecifier => [
			type = owningEnumType
		]
		it.eAdapters.add(new CFileLocationAdapter(enumerator.fileLocation))
	}	
	
	
}