/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml

import com.google.inject.Inject
import org.eclipse.xtext.naming.IQualifiedNameProvider
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.model.sgraph.ScopedElement
import com.yakindu.sct.model.stext.stext.VariableDefinition

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SCXMLDataModelGenerator {

	@Inject
	extension IQualifiedNameProvider
	@Inject
	extension ITypeValueProvider
	@Inject
	extension SCXMLExpressions

	def generate(ScopedElement it) '''
		«IF scopes.map[variables].flatten.filter(VariableDefinition).length > 0»
			<datamodel>
				«FOR variable : scopes.map[variables].flatten.filter(VariableDefinition)»
					<data expr="«variable.expr»" id="«variable.fullyQualifiedName.toString()»" />
				«ENDFOR»
			</datamodel>
		«ENDIF»
	'''

	protected def Object expr(VariableDefinition it) {
		if(initialValue !== null) initialValue.code else type.defaultValue
	}
}
