/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.yakindu.sct.model.sgraph.Entry
import com.yakindu.sct.model.sgraph.State
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.SGraphFactory

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * https://github.com/Yakindu/sctpro/issues/1781
 */
class CompositeStateWithoutEntryModification implements IModification {

	override modify(Statechart statechart) {
		val regions = statechart.eAllContents.filter(State).filter[isComposite].map[regions].toList.flatten
		val regionsWithoutEntry = regions.filter[vertices.filter(Entry).isEmpty && !vertices.filter(State).empty]
		regionsWithoutEntry.forEach [ region |
			val transition = SGraphFactory.eINSTANCE.createTransition
			val entry = SGraphFactory.eINSTANCE.createEntry
			region.vertices += entry
			transition.target = region.vertices.filter(State).head
			transition.source = entry
		]
	}
}
