/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ReactionEffect
import com.yakindu.sct.model.sgraph.Entry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import com.yakindu.sct.model.stext.stext.EntryPointSpec

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class EntryPointModification implements IModification {

	@Inject
	protected extension SgraphExtensions

	override modify(Statechart statechart) {
		val transitions = statechart.eAllContents.filter(Transition).filter [
			properties.exists[it instanceof EntryPointSpec]
		].toList
		transitions.forEach[modify()]
	}

	def protected modify(Transition transition) {
		val entryPointSpec = transition.properties.findFirst[it instanceof EntryPointSpec] as EntryPointSpec
		val entries = transition.target.eAllContents.filter(Entry).toList
		var entry = entries.findFirst[it.name == entryPointSpec.entrypoint]
		if (entry === null)
			entry = entries.findFirst[isDefault]
		if (entry === null)
			return;
		transition.target = entry.outgoingTransitions.head.target;
		val effect = entry.outgoingTransitions.head.effect as ReactionEffect
		if (effect !== null) {
			val targetEffect = (transition.effect as ReactionEffect)
			if(targetEffect === null)
				transition.effect = effect
			else
				targetEffect.actions += effect.actions
			
		}
	}

}
